/*xxx
* \brief -  SCI_PSK_DEM API
* \author maki
*/

#include "sci\sci_psk_dem.hpp"
#include "__debug_level.h"
#include "debug.hpp"

namespace SCI
{

sci_psk_dem::sci_psk_dem()
{
  debug(3) << "sci_psk_dem created \n";
};

sci_psk_dem::~sci_psk_dem()
{
  debug(3) << "sci_psk_dem destroyed \n";
};


/*! sets parameters of a SCI_PSK_DEM \n
<pre>
Supported parameters:
\a SCI_SIZE,      \a sci_var [int] constellation \n
\a SCI_SCALE,     \a sci_var [double] constellation scale, for default scaling determined by size - symbols are in [-1..+1] range \n
\a SCI_OUTPUT,    \a sci_var [int] output for ce=0\n
</pre>
\param [in] param   - parameter to set
\param [in] p_v     - pointer to sci_var object with the value of the parameter
*/
void sci_psk_dem::set(int param, sci_var* p_v)
{

  switch(param)
  {
    case SCI_SIZE:		// size constellation
      set_size(p_v->get_int());
      break;

    case SCI_SCALE:
      set_scale(p_v->get_double());
      break;

    case SCI_OUTPUT:
      set_output(p_v->get_int());
      break;

    default:
      throw sci_exception("sci_psk_mod::set - unknown param");
  }
  return;
};

/*! creates new sci_var object and assigns its value to a parameter of the SCI_PSK_DEM \n
<pre>
Supported parameters:
\a SCI_TYPE,    \a sci_var [int]  \n
\a SCI_SIZE,    \a sci_var [int]  initial output\n
\a SCI_SCALE,   \a sci_var [double]  initial output\n
\a SCI_OUTPUT,  \a sci_var [int]  initial output\n
</pre>
\param [in] param   - parameter to get
\return             - pointer to created sci_var, actual object type depends on input parameter
*/
sci_var* sci_psk_dem::get(int param)
{
  switch (param)
  {
    case SCI_TYPE:
    {
      sci_var* p_sci_var_int = new sci_var_int;
      int &iv = (dynamic_cast<sci_var_int *>(p_sci_var_int))->v;
      iv = SCI_PSK_DEM;
      debug(3) << "sci_psk_mod::get SCI_TYPE iv =" << iv << endl;
      return(p_sci_var_int);
    }

    case SCI_SIZE:
    {
      sci_var* p_sci_var_int = new sci_var_int;
      int &iv = (dynamic_cast<sci_var_int *>(p_sci_var_int))->v;
      iv = get_size();
      debug(3) << "sci_psk_mod::get SCI_SIZE iv =" << iv << endl;
      return(p_sci_var_int);
    }

    case SCI_SCALE:
    {
      sci_var* p_sci_var_double = new sci_var_double;
      double &v = (dynamic_cast<sci_var_double *>(p_sci_var_double))->v;
      v = get_scale();
      debug(3) << "sci_psk_mod::get SCI_SCALE v =" << v << endl;
      return(p_sci_var_double);
    }

    case SCI_OUTPUT:
    {
      sci_var* p_sci_var_int = new sci_var_int;
      int &iv = (dynamic_cast<sci_var_int *>(p_sci_var_int))->v;
      iv = get_output();
      debug(3) << "sci_psk_mod::get SCI_OUTPUT iv =" << iv << endl;
      return(p_sci_var_int);
    }
      
    default:
    throw sci_exception("sci_psk_dem::get - unknown param");
  }
};

/*! executes command in SCI_PSK_DEM object
<pre>
Supported commands:
\a none \n
</pre>
\param [in] command - to be executed
*/
void sci_psk_dem::exec(int command)
{

  throw sci_exception("sci_psk_dem::exec - unknown command");
  return;
};

/*! creates sci_var and assigns its value to the output of SIM::psk_dem::process()\n
\param [in] p_v_ce  - pointer to ce - sci_var [bvec]
\param [in] p_v_x   - pointer to x - sci_var [cvec]
\return             - pointer to y - new sci_var [ivec]
*/
sci_var* sci_psk_dem::proc(sci_var* p_v_ce, sci_var* p_v_x)
{
  sci_var* p_y = new sci_var_ivec;
  ivec &y = (dynamic_cast<sci_var_ivec *>(p_y))->v;

  debug(3) << "sci_psk_dem::proc ce = " << p_v_ce->get_bvec() << endl;
  debug(3) << "sci_psk_dem::proc  x = " << p_v_x->get_cvec() << endl;

  y = process(p_v_ce->get_bvec(), p_v_x->get_cvec());

  debug(3) << "sci_psk_dem::proc  y = " << y << endl;
  return (p_y);
};

} // namespace SCI
