/*xxx
* \brief - SCI_QAM_MOD API
* \author maki
*/

#include "sci\sci_qam_mod.hpp"
#include "__debug_level.h"
#include "debug.hpp"

namespace SCI
{

sci_qam_mod::sci_qam_mod()
{
  debug(3) << "sci_qam_mod created \n";
};

sci_qam_mod::~sci_qam_mod()
{
  debug(3) << "sci_qam_mod destroyed \n";
};

/*! sets parameters of a QAM_MOD \n
<pre>
Supported parameters:
\a SCI_SIZE,        \a sci_var [int]    size of the constellation\n
\a SCI_SCALE,       \a sci_var [dbl]    scale for constellation \n
\a SCI_OUTPUT,      \a sci_var [complex]  output for ce=0\n
</pre>
\param [in] param   - parameter to set
\param [in] p_v     - pointer to sci_var object with value of the parameter
*/
void sci_qam_mod::set(int param, sci_var* p_v)
{

  switch(param)
  {
    case SCI_SIZE:		// size of the constellation
      set_size(p_v->get_int());
      break;

    case SCI_SCALE:
      set_scale(p_v->get_double());
      break;

    case SCI_OUTPUT:
      set_output(p_v->get_complex());
      break;

    default:
      throw sci_exception("sci_qam_mod::set - unknown param");
  }
  return;
};

/*! creates new sci_var object and assign its value to QAM_MOD parameter\n
<pre>
Supported parameters:
\a SCI_TYPE,        \a sci_var [int]   \n
\a SCI_SIZE,        \a sci_var [int]    size of the constellation\n
\a SCI_SCALE,       \a sci_var [dbl]    scale for constellation \n
\a SCI_OUTPUT,      \a sci_var [complex]  output for ce=0\n
</pre>
\param [in] param   - parameter to get
\return             - pointer to created sci_var, actual object type depends on input parameter
*/
sci_var* sci_qam_mod::get(int param)
{
  switch(param)
  {
    case SCI_TYPE:
    {
      sci_var* p_sci_var_int = new sci_var_int;
      int &iv = (dynamic_cast<sci_var_int *>(p_sci_var_int))->v;
      iv = SCI_QAM_MOD;
      debug(3) << "sci_qam_mod::get SCI_TYPE iv =" << iv << endl;
      return(p_sci_var_int);
    }

    case SCI_SIZE:
    {
      sci_var* p_sci_var_int = new sci_var_int;
      int &iv = (dynamic_cast<sci_var_int *>(p_sci_var_int))->v;
      iv = get_size();
      debug(3) << "sci_qam_mod::get SCI_SIZE iv =" << iv << endl;
      return(p_sci_var_int);
    }

    case SCI_SCALE:
    {
      sci_var* p_sci_var_dbl = new sci_var_double;
      double &v = (dynamic_cast<sci_var_double *>(p_sci_var_dbl))->v;
      v = get_scale();
      debug(3) << "sci_qam_mod::get SCI_SCALE v =" << v << endl;
      return(p_sci_var_dbl);
    }

    case SCI_OUTPUT:
    {
      sci_var* p_sci_var_cplx = new sci_var_complex;
      complex<double> &cv = (dynamic_cast<sci_var_complex *>(p_sci_var_cplx))->v;
      cv = get_output();
      debug(3) << "sci_qam_mod::get SCI_OUTPUT cv =" << cv << endl;
      return(p_sci_var_cplx);
    }

    default:
      throw sci_exception("sci_qam_mod::get - unknown param");
  }
};

/*! executes command in an object of a QAM_MOD
<pre>
Supported commands:
\a none \n
</pre>
\param [in] command - to be executed
*/
void sci_qam_mod::exec(int command)
{

  throw sci_exception("sci_qam_mod::exec - unknown command");
  return;

};

/*! creates sci_var and assigns its value to the output of SIM::qam_mod::process()\n
\param [in] p_v_ce  - pointer to ce - sci_var [bvec]
\param [in] p_v_x   - pointer to x - sci_var [ivec]
\return             - pointer to y - new sci_var [cvec]
*/
sci_var* sci_qam_mod::proc(sci_var* p_v_ce, sci_var* p_v_x)
{
  sci_var* p_y = new sci_var_cvec;
  cvec &y = (dynamic_cast<sci_var_cvec *>(p_y))->v;

  debug(3) << "sci_qam_mod::proc ce = " << p_v_ce->get_bvec() << endl;
  debug(3) << "sci_qam_mod::proc  x = " << p_v_x->get_ivec() << endl;

  y = process(p_v_ce->get_bvec(), p_v_x->get_ivec());

  debug(3) << "sci_qam_mod::proc  y = " << y << endl;

  return (p_y);
};

} // namespace SCI
