/*xxx
* \brief - RMS processor for complex signals
* \author maki
*/

#include "sci\sci_rms_x.hpp"
#include "__debug_level.h"
#include "debug.hpp"

namespace SCI
{

sci_rms_x::sci_rms_x()
{
  debug(3) << "sci_rms_x created \n";
};

sci_rms_x::~sci_rms_x()
{
  debug(3) << "sci_rms_x destroyed \n";
};

/*! set parameters of a RMS_X processor \n
<pre>
Supported parameters:
\a SCI_SIZE,    \a sci_var [int]\n
\a SCI_OUTPUT,  \a sci_var [double]\n
</pre>
\param [in] param   - parameter to set
\param [in] p_v     - pointer to sci_var object with value of the parameter
*/
void sci_rms_x::set(int param, sci_var* p_v)
{

  switch(param)
  {
    case SCI_SIZE:
      set_size(p_v->get_int());
      break;

    case SCI_OUTPUT:
      set_output(p_v->get_double());
      break;

    default:
      throw sci_exception("sci_rms_x::set - unknown param");
  }
  return;
};

/*! create new sci_var object and assign its value to RMS processor parameter - param
<pre>
Supported parameters:
\a SCI_TYPE,    \a sci_var [int] \n
\a SCI_SIZE,    \a sci_var [int]\n
\a SCI_OUTPUT,  \a sci_var [double]\n
</pre>
\param [in] param - parameter to get
\return           - pointer to created sci_var
*/
sci_var* sci_rms_x::get(int param)
{
  switch(param)
  {
    case SCI_TYPE:
    {
      sci_var* p_sci_var_int = new sci_var_int;
      int &iv = (dynamic_cast<sci_var_int *>(p_sci_var_int))->v;
      iv = SCI_RMS_X;
      debug(3) << "sci_rms_x::get SCI_TYPE iv =" << p_sci_var_int->get_int() << endl;
      return(p_sci_var_int);
    }

    case SCI_SIZE:
    {
      sci_var* p_sci_var_int = new sci_var_int;
      int &iv = (dynamic_cast<sci_var_int *>(p_sci_var_int))->v;
      iv = get_size();
      debug(3) << "sci_rms_x::get SCI_SIZE iv =" << p_sci_var_int->get_int() << endl;
      return(p_sci_var_int);
    }

    case SCI_OUTPUT:
    {
      sci_var* p_sci_var_double = new sci_var_double;
      double &dv = (dynamic_cast<sci_var_double *>(p_sci_var_double))->v;
      dv = get_output();
      debug(3) << "sci_rms_x::get SCI_OUTPUT v = " << p_sci_var_double->get_double() << endl;
      return(p_sci_var_double);
    }

    default:
      throw sci_exception("sci_rms_x::get - unknown param");
  }

};

/*! execute command for an instance of a RMS_X processor
<pre>
Supported commands: NONE
</pre>
\param [in] command - to be executed
*/
void sci_rms_x::exec(int command)
{

  throw sci_exception("rms_x::exec - unknown command");
  return;
};


/*! process input [x] for active [ce] ticks, assign output to [y], newly created sci_var [vec]
\param [in] p_v_ce  - pointer to ce - sci_var [bvec]
\param [in] p_v_x   - pointer to x  - sci_var [cvec]
\return             - pointer to y - created sci_var [vec]
*/
sci_var* sci_rms_x::proc(sci_var* p_v_ce, sci_var* p_v_x)
{
  sci_var* p_y = new sci_var_vec;	// create sci_var_vec;
  vec &y = (dynamic_cast<sci_var_vec *>(p_y))->v; // alias to vector

  debug(3) << "sci_rms_x::proc ce = " << p_v_ce->get_bvec() << endl;
  debug(3) << "sci_rms_x::proc  x = " << p_v_x->get_cvec() << endl;

  y = process(p_v_ce->get_bvec(), p_v_x->get_cvec());

  debug(3) << "sci_rms_x::proc  y = " << y << endl;
  return (p_y);
};

} // namespace SCI