/*xxx
* \brief - SCI_SRC API
* \author maki
*/

#include "sci\sci_src.hpp"
#include "__debug_level.h"
#include "debug.hpp"

namespace SCI
{

sci_src::sci_src()
{
  debug(3) << "sci_src created \n";
};

sci_src::~sci_src()
{
  debug(3) << "sci_src destroyed \n";
};

/*! sets parameter of a SRC \n
<pre>
Supported parameters:
\a SCI_SIZE,      \a sci_var [int]\n
\a SCI_WIN_TYPE,  \a sci_var [int]\n
\a SCI_OUTPUT,    \a sci_var [double]\n
</pre>
\param [in] param   - parameter to set
\param [in] p_v     - pointer to sci_var object with value of the parameter
*/
void sci_src::set(int param, sci_var* p_v)
{

  switch(param)
  {
    case SCI_SIZE:
      set_size(p_v->get_int());
      break;

    case SCI_WIN_TYPE:
      set_win_type(p_v->get_int());
      break;

    case SCI_OUTPUT:
      set_output(p_v->get_double());
      break;

    default:
      throw sci_exception("sci_src::set - unknown param");
  }
  return;
};

/*! creates new sci_var and assigns its value to the requested parameter of SRC
<pre>
Supported parameters:
\a SCI_TYPE,      \a sci_var [int] \n
\a SCI_SIZE,      \a sci_var [int] \n
\a SCI_WIN_TYPE,  \a sci_var [int]\n
\a SCI_OUTPUT,    \a sci_var [double]\n
</pre>
\param [in] param - parameter to get
\return           - pointer to created sci_var
*/
sci_var* sci_src::get(int param)
{

  switch(param)
  {
    case SCI_TYPE:
    {
      sci_var* p_sci_var_int = new sci_var_int;
      int &iv = (dynamic_cast<sci_var_int *>(p_sci_var_int))->v;
      iv = SCI_SRC;
      debug(3) << "sci_src::get SCI_TYPE iv =" << p_sci_var_int->get_int() << endl;
      return(p_sci_var_int);
    }


    case SCI_SIZE:
    {
      sci_var* p_sci_var_int = new sci_var_int;
      int &iv = (dynamic_cast<sci_var_int *>(p_sci_var_int))->v;
      iv = get_size();
      debug(3) << "sci_src::get SCI_SIZE iv =" << p_sci_var_int->get_int() << endl;
      return(p_sci_var_int);
    }

    case SCI_WIN_TYPE:
    {
      sci_var* p_sci_var_int = new sci_var_int;
      int &iv = (dynamic_cast<sci_var_int *>(p_sci_var_int))->v;
      iv = get_win_type();
      debug(3) << "sci_src::get SCI_WIN_TYPE iv =" << p_sci_var_int->get_int() << endl;
      return(p_sci_var_int);
    }

    case SCI_OUTPUT:
    {
      sci_var* p_sci_var_double = new sci_var_double;
      double &dv = (dynamic_cast<sci_var_double *>(p_sci_var_double))->v;
      dv = get_output();
      debug(3) << "sci_src::get SCI_OUTPUT v = " << p_sci_var_double->get_double() << endl;
      return(p_sci_var_double);
    }

    default:
      throw sci_exception("sci_src::get - unknown param");
  }

};

/*! executes command in an object of a SRC
<pre>
Supported commands:
\a none \n
</pre>
\param [in] command - to be executed
*/
void sci_src::exec(int command)
{
  throw sci_exception("src::exec - unknown command");
  return;
};


/*! creates sci_var and assigns its value to the output of SIM::src::process() \n
\param [in] p_v_ce  - pointer to [cei|ceo] - sci_var [bmat]
\param [in] p_v_x   - pointer to [x|t]  - sci_var [mat]
\return             - pointer to y - created sci_var [vec]
*/
sci_var* sci_src::proc(sci_var* p_v_ce, sci_var* p_v_x)
{
  sci_var* p_y = new sci_var_vec;	
  vec &y = (dynamic_cast<sci_var_vec *>(p_y))->v;

  debug(3) << "sci_src::proc ce= " << p_v_ce->get_bmat() << endl;
  debug(3) << "sci_src::proc  x= " << p_v_x->get_mat() << endl;

  y = process(p_v_ce->get_bmat(), p_v_x->get_mat());

  debug(3) << "sci_src::proc  y= " << y << endl;

  return (p_y);
};

} // namespace SCI