/*xxx
* \brief - SCI_SRC_X API
* \author maki
*/

#include "sci\sci_src_x.hpp"
#include "__debug_level.h"
#include "debug.hpp"


namespace SCI
{

sci_src_x::sci_src_x()
{
  debug(3) << "sci_src_x created \n";
};

sci_src_x::~sci_src_x()
{
  debug(3) << "sci_src_x destroyed \n";
};

/*! sets parameter of a SRC_X \n
<pre>
Supported parameters:
\a SCI_SIZE,      \a sci_var [int]\n
\a SCI_WIN_TYPE,  \a sci_var [int]\n
\a SCI_OUTPUT,    \a sci_var [complex]\n
</pre>
\param [in] param   - parameter to set
\param [in] p_v     - pointer to sci_var object with value of the parameter
*/
void sci_src_x::set(int param, sci_var* p_v)
{
  switch(param)
  {
    case SCI_SIZE:
      set_size(p_v->get_int());
      break;

    case SCI_WIN_TYPE:
      set_win_type(p_v->get_int());
      break;

    case SCI_OUTPUT:
      set_output(p_v->get_complex());
      break;

    default:
      throw sci_exception("sci_src_x::set - unknown param");
  }
  return;
};

/*! creates new sci_var and assigns its value to the requested parameter of SRC_X
<pre>
Supported parameters:
\a SCI_TYPE,      \a sci_var [int] \n
\a SCI_SIZE,      \a sci_var [int] \n
\a SCI_WIN_TYPE,  \a sci_var [int]\n
\a SCI_OUTPUT,    \a sci_var [complex]\n
</pre>
\param [in] param - parameter to get
\return           - pointer to created sci_var
*/

sci_var* sci_src_x::get(int param)
{
  switch(param)
  {
    case SCI_TYPE:
    {
      sci_var* p_sci_var_int = new sci_var_int;
      int &iv = (dynamic_cast<sci_var_int *>(p_sci_var_int))->v;
      iv = SCI_SRC_X;
      debug(3) << "sci_src_x::get SCI_TYPE iv =" << p_sci_var_int->get_int() << endl;
      return(p_sci_var_int);
    }


    case SCI_SIZE:
    {
      sci_var* p_sci_var_int = new sci_var_int;
      int &iv = (dynamic_cast<sci_var_int *>(p_sci_var_int))->v;
      iv = get_size();
      debug(3) << "sci_src_x::get SCI_SIZE iv =" << p_sci_var_int->get_int() << endl;
      return(p_sci_var_int);
    }

    case SCI_WIN_TYPE:
    {
      sci_var* p_sci_var_int = new sci_var_int;
      int &iv = (dynamic_cast<sci_var_int *>(p_sci_var_int))->v;
      iv = get_win_type();
      debug(3) << "sci_src_x::get SCI_WIN_TYPE iv =" << p_sci_var_int->get_int() << endl;
      return(p_sci_var_int);
    }

    case SCI_OUTPUT:
    {
      sci_var* p_sci_var_complex = new sci_var_complex;
      complexd &cv = (dynamic_cast<sci_var_complex *>(p_sci_var_complex))->v;
      cv = get_output();
      debug(3) << "sci_src_x::get SCI_OUTPUT cv = " << p_sci_var_complex->get_complex() << endl;
      return(p_sci_var_complex);
    }

    default:
      throw sci_exception("sci_src_x::get - unknown param");
  }

};

/*! executes command in an object of a SRC
<pre>
Supported commands:
\a none \n
</pre>
\param [in] command - to be executed
*/
void sci_src_x::exec(int command)
{

  throw sci_exception("src_x::exec - unknown command");
  return;
};


/*! creates sci_var and assigns its value to the output of SIM::src_x::process() \n
\param [in] p_v_ce  - pointer to [cei|ceo] - sci_var [bmat]
\param [in] p_v_x   - pointer to [x|t]  - sci_var [cmat]
\return             - pointer to y - created sci_var [cvec]
*/
sci_var* sci_src_x::proc(sci_var* p_v_ce, sci_var* p_v_x)
{
  sci_var* p_y = new sci_var_cvec;
  cvec &y = (dynamic_cast<sci_var_cvec *>(p_y))->v;

  debug(3) << "sci_src_x::proc ce= " << p_v_ce->get_bmat() << endl;
  debug(3) << "sci_src_x::proc  x= " << p_v_x->get_cmat() << endl;

  y = process(p_v_ce->get_bmat(), p_v_x->get_cmat());

  debug(3) << "sci_src_x::proc  y= " << y << endl;

  return (p_y);
};

} // namespace SCI