/*xxx
* \brief - SCI_TEDG_X API
* \author maki
*/

#include "sci\sci_tedg_x.hpp"
#include "__debug_level.h"
#include "debug.hpp"


namespace SCI
{

sci_tedg_x::sci_tedg_x()
{
  debug(3) << "sci_tedg_x created \n";
};

sci_tedg_x::~sci_tedg_x()
{
  debug(3) << "sci_tedg_x destroyed \n";
};

/*! sets parameter of a TEDG_X \n
<pre>
Supported parameters:
\a SCI_MODE,      \a sci_var [int]\n
\a SCI_QUANT,     \a sci_var [double]\n
\a SCI_OUTPUT,    \a sci_var [complex]\n
</pre>
\param [in] param   - parameter to set
\param [in] p_v     - pointer to sci_var object with value of the parameter
*/
void sci_tedg_x::set(int param, sci_var* p_v)
{
  switch(param)
  {
    case SCI_MODE:
      set_mode(p_v->get_int());
      break;

    case SCI_QUANT:
      set_quantum(p_v->get_double());
      break;

    case SCI_OUTPUT:
      set_output(p_v->get_complex());
      break;

    default:
      throw sci_exception("sci_tedg_x::set - unknown param");
  }
  return;
};

/*! creates new sci_var and assigns its value to the requested parameter of TEDG_X
<pre>
Supported parameters:
\a SCI_TYPE,      \a sci_var [int] \n
\a SCI_MODE,      \a sci_var [int] \n
\a SCI_QUANT,     \a sci_var [double]\n
\a SCI_OUTPUT,    \a sci_var [complex]\n
</pre>
\param [in] param - parameter to get
\return           - pointer to created sci_var
*/

sci_var* sci_tedg_x::get(int param)
{
  switch(param)
  {
    case SCI_TYPE:
    {
      sci_var* p_sci_var_int = new sci_var_int;
      int &iv = (dynamic_cast<sci_var_int *>(p_sci_var_int))->v;
      iv = SCI_TEDG_X;
      debug(3) << "sci_tedg_x::get SCI_TYPE iv =" << p_sci_var_int->get_int() << endl;
      return(p_sci_var_int);
    }


    case SCI_MODE:
    {
      sci_var* p_sci_var_int = new sci_var_int;
      int &iv = (dynamic_cast<sci_var_int *>(p_sci_var_int))->v;
      iv = get_mode();
      debug(3) << "sci_tedg_x::get SCI_MODE iv =" << p_sci_var_int->get_int() << endl;
      return(p_sci_var_int);
    }

    case SCI_QUANT:
    {
      sci_var* p_sci_var_double = new sci_var_double;
      double &v = (dynamic_cast<sci_var_double *>(p_sci_var_double))->v;
      v = get_quantum();
      debug(3) << "sci_tedg_x::get SCI_QUANT v =" << p_sci_var_double->get_double() << endl;
      return(p_sci_var_double);
    }

    case SCI_OUTPUT:
    {
      sci_var* p_sci_var_complex = new sci_var_complex;
      complexd &cv = (dynamic_cast<sci_var_complex *>(p_sci_var_complex))->v;
      cv = get_output();
      debug(3) << "sci_tedg_x::get SCI_OUTPUT cv = " << p_sci_var_complex->get_complex() << endl;
      return(p_sci_var_complex);
    }

    default:
      throw sci_exception("sci_tedg_x::get - unknown param");
  }

};

/*! executes command in an object of a TEDG_X
<pre>
Supported commands:
\a none \n
</pre>
\param [in] command - to be executed
*/
void sci_tedg_x::exec(int command)
{

  throw sci_exception("src_x::exec - unknown command");
  return;
};


/*! creates sci_var and assigns its value to the output of SIM::tedg_x::process() \n
\param [in] p_v_ce  - pointer to [cei|ceo] - sci_var [bmat]
\param [in] p_v_x   - pointer to [x]  - sci_var [cvec]
\return             - pointer to y - created sci_var [cvec]
*/
sci_var* sci_tedg_x::proc(sci_var* p_v_ce, sci_var* p_v_x)
{
  sci_var* p_y = new sci_var_cvec;
  cvec &y = (dynamic_cast<sci_var_cvec *>(p_y))->v;

  debug(3) << "sci_tedg_x::proc ce= " << p_v_ce->get_bmat() << endl;
  debug(3) << "sci_tedg_x::proc  x= " << p_v_x->get_cvec() << endl;

  y = process(p_v_ce->get_bmat(), p_v_x->get_cvec());

  debug(3) << "sci_tedg_x::proc  y= " << y << endl;

  return (p_y);
};

} // namespace SCI