/*xxx
* \brief SCI_VCO API
* \author maki
*/

#include "sci\sci_vco.hpp"
#include "__debug_level.h"
#include "debug.hpp"

namespace SCI
{

sci_vco::sci_vco()
{
  debug(3) << "sci_vco created \n";
};

sci_vco::~sci_vco()
{
  debug(3) << "sci_vco destroyed \n";
};

/*! set parameters of a floating point NCO - numerically controlled oscillator\n
<pre>
Supported parameters:
\a SCI_ACC,     \a sci_var [double] phase accumulator in double fractional format\n
\a SCI_OUTPUT,  \a sci_var [vec] initial output value y0 = [cy|ph]\n
</pre>
\param [in] param   - parameter to set
\param [in] p_v     - pointer to sci_var object with value of the parameter
*/
void sci_vco::set(int param, sci_var* p_v)
{

  switch(param)
  {
    case SCI_ACC:
      debug(3) << "sci_vco::set SCI_ACC  v = " << p_v->get_double() << endl;
      set_acc(p_v->get_double());
      break;

    case SCI_OUTPUT:
      debug(3) << "sci_vco::set SCI_OUTPUT  v=" << p_v->get_vec() << endl;
      set_output(p_v->get_vec());
      break;

    default:
      throw sci_exception("sci_vco::set - unknown param");
  }
  return;
};

/*! create new sci_var object and assign a its value to floating point NCO parameter
<pre>
Supported parameters:
\a SCI_TYPE,    \a sci_var [int] \n
\a SCI_ACC,     \a sci_var [double] phase accumulator state in double fractional format\n
\a SCI_OUTPUT,  \a sci_var [vec] initial output value y0 = [cy|ph]\n
</pre>
\param [in] param - parameter to get
\return           - pointer to created sci_var, actual object type depends on input parameter
*/
sci_var* sci_vco::get(int param)
{
  sci_var* p_sci_var_vec = new sci_var_vec;	// create sci_var_vec;
  vec &v = (dynamic_cast<sci_var_vec *>(p_sci_var_vec))->v; // alias to vector


  switch(param)
  {
    case SCI_TYPE:
    {
      sci_var* p_sci_var_int = new sci_var_int;
      int &iv = (dynamic_cast<sci_var_int *>(p_sci_var_int))->v;
      iv = SCI_VCO;
      debug(3) << "sci_vco::get SCI_TYPE iv =" << iv << endl;
      return(p_sci_var_int);
    }

    case SCI_ACC:
    {
      sci_var* p_sci_var_double = new sci_var_double;
      double &v = (dynamic_cast<sci_var_double *>(p_sci_var_double))->v;
      v = get_acc();
      debug(3) << "sci_vco::get SCI_ACC v =" << v << endl;
      return(p_sci_var_double);
    }

    case SCI_OUTPUT:
    {
      sci_var* p_sci_var_vec = new sci_var_vec;
      vec &v = (dynamic_cast<sci_var_vec *>(p_sci_var_vec))->v;
      v = get_output();
      debug(3) << "sci_vco::get SCI_OUTPUT v =" << v << endl;
      return(p_sci_var_vec);
    }

    default:
      throw sci_exception("sci_vco::get - unknown param");
  }

};

/*! execute command for an instance of a VCO \n
Supported commands:\n
none
\param [in] command - to be executed
*/
void sci_vco::exec(int command)
{
  throw sci_exception("sci_vco::exec - unknown command");
  return;
};

/*! return VCO output [y]=[cy|ph] in newly created sci_var [mat]
for active [ce] ticks, double fractional phase accumulator sums fractional frequency control words in [x]
\param [in] p_v_ce  - pointer to ce - sci_var [bvec]
\param [in] p_v_x   - pointer to x  - sci_var [vec]
\return             - pointer to y - created sci_var [mat]=[cy|ph]
*/
sci_var* sci_vco::proc(sci_var* p_v_ce, sci_var* p_v_x)
{
  sci_var* p_y = new sci_var_mat;	// create
  mat &y = (dynamic_cast<sci_var_mat *>(p_y))->v; // alias

  debug(3) << " sci_vco::proc ce = " << p_v_ce->get_bvec() << endl;
  debug(3) << " sci_vco::proc  x = " << p_v_x->get_vec() << endl;

  y = process(p_v_ce->get_bvec(), p_v_x->get_vec());

  debug(3) << " sci_vco::proc  y = " << y << endl;

  return (p_y);
};

} // namespace SCI