/*xxx
* \brief - SCI_WGN API
* \author maki
*/

#include "sci\sci_wgn.hpp"
#include "__debug_level.h"
#include "debug.hpp"

namespace SCI
{

sci_wgn::sci_wgn()
{
  debug(3) << "sci_wgn created \n";
};

sci_wgn::~sci_wgn()
{
  debug(3) << "sci_wgn destroyed \n";
};

/*! set parameters of a WGN generator \n
<pre>
Supported parameters:
\a SCI_SIGMA,    \a sci_var [double]\n
\a SCI_MEAN,    \a sci_var [double]\n
\a SCI_OUTPUT,   \a sci_var [double]\n
</pre>
\param [in] param   - parameter to set
\param [in] p_v     - pointer to sci_var object with value of the parameter
*/

void sci_wgn::set(int param, sci_var* p_v)
{

  switch(param)
  {
    case SCI_SIGMA:
      set_sigma(p_v->get_double());
      break;

    case SCI_MEAN:
      set_mean(p_v->get_double());
      break;

    case SCI_OUTPUT:
      set_output(p_v->get_double());
      break;

    default:
      throw sci_exception("sci_wgn::set - unknown param");
  }
  return;
};

/*! create new sci_var object and assign its value to WGN generator parameter - param
<pre>
Supported parameters:
\a SCI_TYPE,    \a sci_var [int] \n
\a SCI_SIGMA,    \a sci_var [double]\n
\a SCI_MEAN,    \a sci_var [double]\n
\a SCI_OUTPUT,   \a sci_var [double]\n
</pre>
\param [in] param - parameter to get
\return           - pointer to created sci_var
*/
sci_var* sci_wgn::get(int param)
{

  switch(param)
  {
    case SCI_TYPE:
    {
      sci_var* p_sci_var_int = new sci_var_int;	
      int &iv = (dynamic_cast<sci_var_int *>(p_sci_var_int))->v;
      iv = SCI_WGN;
      debug(3) << "sci_wgn::get SCI_TYPE iv =" << p_sci_var_int->get_int() << endl;
      return(p_sci_var_int);
    }


    case SCI_SIGMA:
    {
      sci_var* p_sci_var_double = new sci_var_double;
      double &dv = (dynamic_cast<sci_var_double *>(p_sci_var_double))->v;
      dv = get_sigma();
      debug(3) << "sci_wgn::get SCI_SIGMA v = " << p_sci_var_double->get_double() << endl;
      return(p_sci_var_double);
    }

    case SCI_MEAN:
    {
      sci_var* p_sci_var_double = new sci_var_double;
      double &dv = (dynamic_cast<sci_var_double *>(p_sci_var_double))->v;
      dv = get_mean();
      debug(3) << "sci_wgn::get SCI_MEAN v = " << p_sci_var_double->get_double() << endl;
      return(p_sci_var_double);
    }

    case SCI_OUTPUT:
    {
      sci_var* p_sci_var_double = new sci_var_double;
      double &dv = (dynamic_cast<sci_var_double *>(p_sci_var_double))->v;
      dv = get_output();
      debug(3) << "sci_wgn::get SCI_OUTPUT v = " << p_sci_var_double->get_double() << endl;
      return(p_sci_var_double);
    }

    default:
      throw sci_exception("sci_wgn::get - unknown param");
  }

};

/*! execute command for an instance of a WGN generator
<pre>
Supported commands: NONE
</pre>
\param [in] command - to be executed
*/
void sci_wgn::exec(int command)
{
  throw sci_exception("wgn::exec - unknown command");
  return;
};

/*! for active [ce] ticks, assign output to [y], newly created sci_var [vec]
\param [in] p_v_ce  - pointer to ce - sci_var [bvec]
\return             - pointer to y - created sci_var [vec]
*/
sci_var* sci_wgn::gen(sci_var* p_v_ce)
{
  sci_var* p_y = new sci_var_vec;
  vec &y = (dynamic_cast<sci_var_vec *>(p_y))->v;

  debug(3) << "sci_wgn::gen ce = " << p_v_ce->get_bvec() << endl;

  y = generate(p_v_ce->get_bvec());

  debug(3) << "sci_wgn::gen  y = " << y << endl;
  return (p_y);
};

} // namespace SCI