/*xxx
* \brief - SCI_WGN_X API
* \author maki
*/

#include "sci\sci_wgn_x.hpp"
#include "__debug_level.h"
#include "debug.hpp"


namespace SCI
{

sci_wgn_x::sci_wgn_x()
{
  debug(3) << "sci_wgn_x created \n";
};

sci_wgn_x::~sci_wgn_x()
{
  debug(3) << "sci_wgn_x destroyed \n";
};

/*! set parameters of a WGN_X generator \n
<pre>
Supported parameters:
\a SCI_SIGMA,    \a sci_var [double]\n
\a SCI_MEAN,     \a sci_var [complex]\n
\a SCI_OUTPUT,   \a sci_var [complex]\n
</pre>
\param [in] param   - parameter to set
\param [in] p_v     - pointer to sci_var object with value of the parameter
*/
void sci_wgn_x::set(int param, sci_var* p_v)
{
  switch(param)
  {
    case SCI_SIGMA:
      debug(3) << "sci_wgn_x::set SCI_SIGMA v =" << p_v->get_double() << endl;
      set_sigma(p_v->get_double());
      break;

    case SCI_MEAN:
      debug(3) << "sci_wgn_x::set SCI_MEAN v =" << p_v->get_complex() << endl;
      set_mean(p_v->get_complex());
      break;

    case SCI_OUTPUT:
      debug(3) << "sci_wgn_x::set SCI_OUTPUT v =" << p_v->get_complex() << endl;
      set_output(p_v->get_complex());
      break;

    default:
      throw sci_exception("sci_wgn_x::set - unknown param");
  }
  return;
};

/*! create new sci_var object and assign its value to WGN_X generator parameter - param
<pre>
Supported parameters:
\a SCI_TYPE,    \a sci_var [int] \n
\a SCI_SIGMA,   \a sci_var [double]\n
\a SCI_MEAN,    \a sci_var [complex]\n
\a SCI_OUTPUT,  \a sci_var [complex]\n
</pre>
\param [in] param - parameter to get
\return           - pointer to created sci_var
*/
sci_var* sci_wgn_x::get(int param)
{

  switch(param)
  {
    case SCI_TYPE:
    {
      sci_var* p_sci_var_int = new sci_var_int;
      int &iv = (dynamic_cast<sci_var_int *>(p_sci_var_int))->v;
      iv = SCI_WGN_X;
      debug(3) << "sci_wgn_x::get SCI_TYPE iv =" << p_sci_var_int->get_int() << endl;
      return(p_sci_var_int);
    }

    case SCI_SIGMA:
    {
      sci_var* p_sci_var_double = new sci_var_double;
      double &dv = (dynamic_cast<sci_var_double *>(p_sci_var_double))->v;
      dv = get_sigma();
      debug(3) << "sci_wgn_x::get SCI_SIGMA v = " << p_sci_var_double->get_double() << endl;
      return(p_sci_var_double);
    }

    case SCI_MEAN:
    {
      sci_var* p_sci_var_complex = new sci_var_complex;
      complexd &cv = (dynamic_cast<sci_var_complex *>(p_sci_var_complex))->v;
      cv = get_mean();
      debug(3) << "sci_wgn_x::get SCI_MEAN v = " << p_sci_var_complex->get_complex() << endl;
      return(p_sci_var_complex);
    }

    case SCI_OUTPUT:
    {
      sci_var* p_sci_var_complex = new sci_var_complex;
      complexd &cv = (dynamic_cast<sci_var_complex *>(p_sci_var_complex))->v;
      cv = get_output();
      debug(3) << "sci_wgn_x::get SCI_OUTPUT v = " << p_sci_var_complex->get_complex() << endl;
      return(p_sci_var_complex);
    }

    default:
      throw sci_exception("sci_wgn_x::get - unknown param");
  }

};

/*! execute command for an instance of a WGN_X generator
<pre>
Supported commands: NONE
</pre>
\param [in] command - to be executed
*/
void sci_wgn_x::exec(int command)
{

  throw sci_exception("wgn_x::exec - unknown command");
  return;
};

/*! for active [ce] ticks, assign output to [y], newly created sci_var [cvec]
\param [in] p_v_ce  - pointer to ce - sci_var [bvec]
\return             - pointer to y - created sci_var [cvec]
*/
sci_var* sci_wgn_x::gen(sci_var* p_v_ce)
{
  sci_var* p_y = new sci_var_cvec;
  cvec &y = (dynamic_cast<sci_var_cvec *>(p_y))->v;

  debug(3) << "sci_wgn_x::gen ce = " << p_v_ce->get_bvec() << endl;

  y = generate(p_v_ce->get_bvec());

  debug(3) << "sci_wgn_x::gen  y = " << y << endl;
  return (p_y);
};

} // namespace SCI