/*xxx
* \brief - first layer interface to the sci_gateway
* Data are on scilab local stack, functions are redirected by gateway
* \n Code has to be pure C due to the problems with mex.h in C++
* \author maki
*/


#ifdef __cplusplus
extern "C" {
#endif

#include "scicoslab\scicoslab_gate.h"
#include "sci\_sci_if.h"
#include "sci\_sci_enum_def.h"
#include "sci\_sci_types.h"


#include "_sci_if_var_struct.h"

#include "__debug.h"


  /*!
   * \brief C interface to scilab sci_create
   *
   * Example: p_fir1=sci_create(SCI_FIR);
   * input SCI_FIR = type of SCI_TYPE object
   * output p_fir1 = pointer to new instance of object
   */

  static int scicoslab_err = SCI_ERR_OK;
  static int scicoslab_info = 0;
  static char scicoslab_err_msg[SCI_ERR_MSG_LEN];

  void sci_if_err_set(int e)
  {
    scicoslab_err = e;
  }

  void sci_if_err_msg_set(const char *p_msg)
  {
    strcpy_s(scicoslab_err_msg, SCI_ERR_MSG_LEN, p_msg);
  }

  void sci_if_info_set(int i)
  {
    scicoslab_info = i;
  }


  int scicoslab_create(char *fname)
  {
    static int l1, m1, n1;
    static int l2, m2, n2;
    static int minlhs = 1, maxlhs = 1;
    static int minrhs = 1, maxrhs = 1;
    static int err;
    void *p_sci;

    debug_1("[scicoslab_create] ..................... \r\n");
    CheckRhs(minrhs, maxrhs);
    CheckLhs(minlhs, maxlhs);
    // Example: SCI_FIR
    GetRhsVar(1, "i", &m1, &n1, &l1);

    p_sci = sci_if_create(*(istk(l1)));

    if(p_sci == NULL)
    {
      Scierror(999, "%s failed err=%d", fname, scicoslab_err);
    }
    else
    {
      /* see C:\Program Files\scicoslab-44b7\examples\interface-tour-so\ex10intc.c */
      m2 = 1;
      n2 = 1;
      CreateVarFromPtr(2, "p", &m2, &n2, p_sci);
      LhsVar(1) = 2; /* return pointer */
    }
    debug_1("p_sci = 0x%X \r\n", p_sci);
    debug_1("[scicoslab_create] +++++++++++++++++++++ \r\n");
    return 0;
  }

  /*!
   * \brief C interface to sci_set
   *
   * Example: sci_set(p_fir1,SCI_TAPS,c0);
   * input1 p_fir1= pointer to the instance SCI_TYPE object
   * input2 SCI_TAPS = type of data
   * input3 c0 = vec
   * output NONE
   */

  int scicoslab_set(char *fname)
  {
    static int l1, m1, n1;
    void *p_sci;
    static int l2, m2, n2;
    static int lr3, lc3, it3, m3, n3;
    static int minrhs = 3, maxrhs = 3;
    static int err;
    struct var_struct s_v;

    SciIntMat M1;
    sci_types sci_var_type;

    debug_3("[scicoslab_set] ..................... \r\n");
    CheckRhs(minrhs, maxrhs);
    // example: pfir1
    /* see C:\Program Files\scicoslab-44b7\examples\interface-tour-so\ex10intc.c */
    m1 = 1;
    n1 = 1;
    GetRhsVar(1, "p", &m1, &n1, &l1);
    // example: SCI_TAPS
    GetRhsVar(2, "i", &m2, &n2, &l2); // this is an enum
    // example: c0
    sci_var_type = GetType(3);
    switch(sci_var_type)
    {
      case sci_matrix: // "1 - A matrix of doubles\n"
        GetRhsCVar(3, "d", &it3, &m3, &n3, &lr3, &lc3);
        if(it3)
        {
          s_v.sci_type = SCI_TYPE_CMAT;
          s_v.p_external.re_im.p_re = stk(lr3);
          s_v.p_external.re_im.p_im = stk(lc3);

        }
        else
        {
          s_v.sci_type = SCI_TYPE_MAT;
          s_v.p_external.p_double = stk(lr3);
        }
        break;
      case sci_boolean: // "4 - A matrix of booleans\n";
        GetRhsVar(3, "b", &m3, &n3, &lr3);
        s_v.sci_type = SCI_TYPE_BMAT;
        s_v.p_external.p_bool = istk(lr3);
        break;
      case sci_ints:  // "8 - A matrix of integers\n - 32bit nothing else";
        // This is coded as in an example: modnum_422\ intmodnum_lib.c\ int intspread_c(char *fname)
        GetRhsVar(3, "I", &m3, &n3, &M1);
        // check the type of int (M1.it==I_INT32 | M1.it==I_UINT32) - only INT32 is supported by ivec
        s_v.sci_type = SCI_TYPE_IMAT;
        s_v.p_external.p_int = M1.D;
        break;
      default:
        Scierror(999, "[scicoslab_set]:Unsupported argument type %s failed err=", fname, -1);
        break;
    }
    s_v.rows = m3;
    s_v.cols = n3;
    s_v.p_var = NULL;
    /* see C:\Program Files\scicoslab-44b7\examples\interface-tour-so\ex10intc.c */
    p_sci = (void *)((unsigned long int) * stk(l1));

    sci_if_set(p_sci, *istk(l2), &s_v); //
    if(scicoslab_err)
    {
      sciprint("\n%s:\n info:%d\n", scicoslab_err_msg, scicoslab_info);
      Scierror(999, "%s failed err=%d", fname, scicoslab_err);
      return 0;
    }
    debug_3("[scicoslab_set] +++++++++++++++++++++ \r\n");
    return 0;

  }

  /*!
   * \brief C interface to sci_get
   *
   * Example: c0 = sci_get(p_fir1,SCI_TAPS);
   * input1 p_fir1 = pointer to the instance of SCI_TYPE object
   * input2 SCI_TAPS = type of data
   * output c0 = vec
   */

  int scicoslab_get(char *fname)
  {
    static int l1, m1, n1;
    void *p_sci;
    static int l2, m2, n2;
    static int lr3, lc3;
    static int minrhs = 2, maxrhs = 2;
    static int minlhs = 0, maxlhs = 1;
    static int err;
    struct var_struct s_v;


    debug_3("[scicoslab_get] ..................... \r\n");
    CheckRhs(minrhs, maxrhs);
    CheckLhs(minlhs, maxlhs);
    // example: pfir1
    m1 = 1;
    n1 = 1;
    GetRhsVar(1, "p", &m1, &n1, &l1);
    // example: SCI_TAPS
    GetRhsVar(2, "i", &m2, &n2, &l2);

    p_sci = (void *)((unsigned long int) * stk(l1));
    s_v = sci_if_get(p_sci, *istk(l2));

    if(scicoslab_err)
    {
      sciprint("\n%s:\n info:%d\n", scicoslab_err_msg, scicoslab_info);
      Scierror(999, "%s failed err=%d", fname, scicoslab_err);
      return 0;
    }
    // now when m3,n3 are set - create [mxn] sci variable on stack (it=is_complex)
    switch(s_v.sci_type)
    {
      case SCI_TYPE_DOUBLE:
      case SCI_TYPE_VEC:
      case SCI_TYPE_MAT:
      {
        int it3 = 0;
        CreateCVar(3, "d", &it3, &s_v.rows, &s_v.cols, &lr3, &lc3);
        s_v.p_external.p_double = stk(lr3);
      }
      break;
      case SCI_TYPE_COMPLEX:
      case SCI_TYPE_CVEC:
      case SCI_TYPE_CMAT:
      {
        int it3 = 1;
        CreateCVar(3, "d", &it3, &s_v.rows, &s_v.cols, &lr3, &lc3);
        // allocated mem on scilab stack for [mxn] of (complex) double
        s_v.p_external.re_im.p_re = stk(lr3);
        s_v.p_external.re_im.p_im = stk(lc3);
      }
      break;
      case SCI_TYPE_BOOL:
      case SCI_TYPE_BVEC:
      case SCI_TYPE_BMAT:
      {
        CreateVar(3, "b", &s_v.rows, &s_v.cols, &lr3);
        // allocated mem on scilab stack for [mxn] boolean
        s_v.p_external.p_bool = istk(lr3);
      }
      break;
      case SCI_TYPE_INT:
      case SCI_TYPE_IVEC:
      case SCI_TYPE_IMAT:
      {
        lr3 = I_INT32;
        CreateVar(3, "I", &s_v.rows, &s_v.cols, &lr3);
        // allocated mem on scilab stack for [mxn] of INT32
        s_v.p_external.p_int = istk(lr3);
      }
      break;
      default:
        Scierror(999, "[scicoslab_get]:Unsupported argument type %s failed err=", fname, -1);
        break;

    }

    // copy values
    sci_if_copy_var(&s_v);
    // remove data from heap
    sci_if_delete_var(&s_v);
    LhsVar(1) = 3; /* return var */
    debug_3("[scicoslab_get] +++++++++++++++++++++ \r\n");
    return 0;
  }

  /*!
   * \brief C interface to sci_exec
   *
   * Example: sci_exec(p_fir1,SCI_RESET);
   * input1 p_fir1 = pointer to the instance of SCI_TYPE object
   * input2 SCI_RESET = type of command
   * output NONE
   */

  int scicoslab_exec(char *fname)
  {
    static int l1, m1, n1;
    void *p_sci;
    static int l2, m2, n2;
    static int minrhs = 2, maxrhs = 2;
    static int err;

    debug_3("[scicoslab_exec] ..................... \r\n");
    CheckRhs(minrhs, maxrhs);
    // example: pfir1
    m1 = 1;
    n1 = 1;
    GetRhsVar(1, "p", &m1, &n1, &l1);
    // example: SCI_RESET
    GetRhsVar(2, "i", &m2, &n2, &l2);
    p_sci = (void *)((unsigned long int) * stk(l1));
    sci_if_exec(p_sci, *(istk(l2)));
    if(scicoslab_err)
    {
      sciprint("\n%s:\n info:%d\n", scicoslab_err_msg, scicoslab_info);
      Scierror(999, "%s failed err=%d", fname, scicoslab_err);
      return 0;
    }
    debug_3("[scicoslab_exec] +++++++++++++++++++++ \r\n");
    return 0;
  }

  /*!
   * \brief C interface to sci_gen
   *
   * Example: y = sci_gen(p_mod,ce);
   * input1 p_mod = pointer to the instance of SCI_TYPE object
   * input2 ce =
   * output y  =
   */

  int scicoslab_gen(char *fname)
  {
    static int l1, m1, n1;
    void *p_sci;
    static int l2, m2, n2;
    static int lr3, lc3;

    static int minrhs = 2, maxrhs = 2;
    static int minlhs = 1, maxlhs = 1;
    static int err = 0;

    struct var_struct s_ce;
    struct var_struct s_y;

    debug_3("[scicoslab_gen] ..................... \r\n");
    CheckRhs(minrhs, maxrhs);
    CheckLhs(minlhs, maxlhs);
    // Example:pfir1
    m1 = 1;
    n1 = 1;
    GetRhsVar(1, "p", &m1, &n1, &l1);
    // Example:ce -  boolean
    GetRhsVar(2, "b", &m2, &n2, &l2);
    s_ce.sci_type = SCI_TYPE_BMAT;
    s_ce.p_var = NULL;
    s_ce.p_external.p_bool = istk(l2);
    s_ce.rows = m2;
    s_ce.cols = n2;

    p_sci = (void *)((unsigned long int) * stk(l1));
    s_y = sci_if_gen(p_sci, &s_ce);
    if(scicoslab_err)
    {
      sciprint("\n%s:\n info:%d\n", scicoslab_err_msg, scicoslab_info);
      Scierror(999, "%s failed err=%d", fname, scicoslab_err);
      return 0;
    }
    // now when m3,n3 and type are set - create [mxn] sci variable on stack
    switch(s_y.sci_type)
    {
      case SCI_TYPE_DOUBLE:
      case SCI_TYPE_VEC:
      case SCI_TYPE_MAT:
      {
        int it3 = 0;
        CreateCVar(3, "d", &it3, &s_y.rows, &s_y.cols, &lr3, &lc3);
        s_y.p_external.p_double = stk(lr3);
      }
      break;
      case SCI_TYPE_COMPLEX:
      case SCI_TYPE_CVEC:
      case SCI_TYPE_CMAT:
      {
        int it3 = 1;
        CreateCVar(3, "d", &it3, &s_y.rows, &s_y.cols, &lr3, &lc3);
        // allocated mem on scilab stack for [mxn] of (complex) double
        s_y.p_external.re_im.p_re = stk(lr3);
        s_y.p_external.re_im.p_im = stk(lc3);
      }
      break;
      case SCI_TYPE_BOOL:
      case SCI_TYPE_BVEC:
      case SCI_TYPE_BMAT:
      {
        CreateVar(3, "b", &s_y.rows, &s_y.cols, &lr3);
        // allocated mem on scilab stack for [mxn] boolean
        s_y.p_external.p_bool = istk(lr3);
      }
      break;
      case SCI_TYPE_INT:
      case SCI_TYPE_IVEC:
      case SCI_TYPE_IMAT:
      {
        lr3 = I_INT32;
        CreateVar(3, "I", &s_y.rows, &s_y.cols, &lr3);
        // allocated mem on scilab stack for [mxn] of INT32
        s_y.p_external.p_int = istk(lr3);
      }
      break;
      default:
        Scierror(999, "[scicoslab_gen]:Unsupported argument type %s failed err=", fname, -1);
    }
    // copy values
    sci_if_copy_var(&s_y);
    // remove data from heap
    sci_if_delete_var(&s_y);
    LhsVar(1) = 3; /* return var */
    debug_3("[scicoslab_gen] +++++++++++++++++++++ \r\n");
    return 0;
  }



  /*!
   * \brief C interface to sci_proc
   *
   * Example: y = sci_proc(p_fir1,ce,x);
   * input1 p_fir1 = pointer to the instance of SCI_TYPE object
   * input2 ce
   * input2 x
   * output y
   */

  int scicoslab_proc(char *fname)
  {
    static int l1, m1, n1;
    void *p_sci;
    static int l2, m2, n2;
    static int lr3, lc3, it3, m3, n3;
    static int lr4, lc4;
    static int minrhs = 3, maxrhs = 3;
    static int minlhs = 1, maxlhs = 1;
    static int err = 0;
    struct var_struct s_ce;
    struct var_struct s_x;
    struct var_struct s_y;

    SciIntMat M1;
    sci_types sci_var_type;

    debug_3("[scicoslab_proc] ..................... \r\n");
    CheckRhs(minrhs, maxrhs);
    CheckLhs(minlhs, maxlhs);
    // Example:pfir1
    m1 = 1;
    n1 = 1;
    GetRhsVar(1, "p", &m1, &n1, &l1);
    // Example:ce -  boolean
    GetRhsVar(2, "b", &m2, &n2, &l2);
    s_ce.sci_type = SCI_TYPE_BMAT;
    s_ce.p_external.p_bool = istk(l2);
    s_ce.rows = m2;
    s_ce.cols = n2;
    s_ce.p_var = NULL;
    // Example:x
    sci_var_type = GetType(3);
    switch(sci_var_type)
    {
      case sci_matrix: // "1 - A matrix of doubles\n"
        GetRhsCVar(3, "d", &it3, &m3, &n3, &lr3, &lc3);
        if(it3)
        {
          s_x.sci_type = SCI_TYPE_CMAT;
          s_x.p_external.re_im.p_re = stk(lr3);
          s_x.p_external.re_im.p_im = stk(lc3);

        }
        else
        {
          s_x.sci_type = SCI_TYPE_MAT;
          s_x.p_external.p_double = stk(lr3);
        }
        break;
      case sci_boolean: // "4 - A matrix of booleans\n";
        GetRhsVar(3, "b", &m3, &n3, &lr3);
        s_x.sci_type = SCI_TYPE_BMAT;
        s_x.p_external.p_bool = istk(lr3);
        break;
      case sci_ints:  // "8 - A matrix of integers\n - 32bit nothing else";
        // This is coded as in an example: modnum_422\ intmodnum_lib.c\ int intspread_c(char *fname)
        GetRhsVar(3, "I", &m3, &n3, &M1);
        // check the type of int (M1.it==I_INT32 | M1.it==I_UINT32) - only INT32 is supported by ivec
        s_x.sci_type = SCI_TYPE_IMAT;
        s_x.p_external.p_int = M1.D;
        break;
      default:
        Scierror(999, "[scicoslab_proc]:Unsupported argument type %s failed err=", fname, -1);
        break;
    }
    s_x.rows = m3;
    s_x.cols = n3;
    s_x.p_var = NULL;

    p_sci = (void *)((unsigned long int) * stk(l1));
    s_y = sci_if_proc(p_sci, &s_ce, &s_x);
    if(scicoslab_err)
    {
      sciprint("\n%s:\n info:%d\n", scicoslab_err_msg, scicoslab_info);
      Scierror(999, "%s failed err=%d", fname, scicoslab_err);
      return 0;
    }
    // now when m4,n4 and type are set - create [mxn] sci variable
    switch(s_y.sci_type)
    {
      case SCI_TYPE_DOUBLE:
      case SCI_TYPE_VEC:
      case SCI_TYPE_MAT:
      {
        int it4 = 0;
        CreateCVar(4, "d", &it4, &s_y.rows, &s_y.cols, &lr4, &lc4);
        s_y.p_external.p_double = stk(lr4);
      }
      break;
      case SCI_TYPE_COMPLEX:
      case SCI_TYPE_CVEC:
      case SCI_TYPE_CMAT:
      {
        int it4 = 1;
        CreateCVar(4, "d", &it4, &s_y.rows, &s_y.cols, &lr4, &lc4);
        // allocated mem on scilab stack for [mxn] of (complex) double
        s_y.p_external.re_im.p_re = stk(lr4);
        s_y.p_external.re_im.p_im = stk(lc4);
      }
      break;
      case SCI_TYPE_BOOL:
      case SCI_TYPE_BVEC:
      case SCI_TYPE_BMAT:
      {
        CreateVar(4, "b", &s_y.rows, &s_y.cols, &lr4);
        // allocated mem on scilab stack for [mxn] boolean
        s_y.p_external.p_bool = istk(lr4);
      }
      break;
      case SCI_TYPE_INT:
      case SCI_TYPE_IVEC:
      case SCI_TYPE_IMAT:
      {
        lr4 = I_INT32;
        CreateVar(4, "I", &s_y.rows, &s_y.cols, &lr4);
        // allocated mem on scilab stack for [mxn] of INT32
        s_y.p_external.p_int = istk(lr4);
      }
      break;
      default:
        Scierror(999, "[scicoslab_proc]:Unsupported argument type %s failed err=", fname, -1);
    }

    // copy values
    sci_if_copy_var(&s_y);
    // remove data from heap
    sci_if_delete_var(&s_y);
    LhsVar(1) = 4; /* return var */
    debug_3("[scicoslab_proc] +++++++++++++++++++++ \r\n");
    return 0;

  }

  /*!
   * \brief C interface to scilab sci_destroy
   *
   * Example: sci_destroy(p_fir1);
   * input SCI_FIR = type of SCI_TYPE object
   * output void
   */

  int scicoslab_destroy(char *fname)
  {
    static int l1, m1, n1;
    void *p_sci;
    static int minrhs = 1, maxrhs = 1;

    debug_1("[scicoslab_destroy] ..................... \r\n");
    CheckRhs(minrhs, maxrhs);
    // Example:pfir1
    m1 = 1;
    n1 = 1;
    GetRhsVar(1, "p", &m1, &n1, &l1);
    p_sci = (void *)((unsigned long int) * stk(l1));
    debug_1("p_sci = 0x%X \r\n",  p_sci);
    sci_if_destroy(p_sci);
    if(scicoslab_err)
    {
      sciprint("\n%s:\n info:%d\n", scicoslab_err_msg, scicoslab_info);
      Scierror(999, "%s failed err=%d", fname, scicoslab_err);
      return 0;
    }
    debug_1("[scicoslab_destroy] +++++++++++++++++++++ \r\n");
    return 0;
  }


#ifdef __cplusplus
}
#endif

