/*xxx
* \brief define conversion operators (it++) <-> (external memory)
* \author maki
*/

#include "sci\_sci_if_op.hpp"

using namespace itpp;
using namespace std;

void push_to_ext_stack(var_struct *p_sci, const double &v)
{
  *(p_sci->p_external.p_double) = v;
}

void pop_from_ext_stack(double &v , const var_struct *p_sci)
{
  v = *(p_sci->p_external.p_double);
}


void push_to_ext_stack(var_struct *p_sci, const complex<double> &v)
{
  *(p_sci->p_external.re_im.p_re) = v.real();
  *(p_sci->p_external.re_im.p_im) = v.imag();
}

void pop_from_ext_stack(complex<double> &v, const var_struct *p_sci)
{
  v = complex<double>(*(p_sci->p_external.re_im.p_re), *(p_sci->p_external.re_im.p_im));
}

void push_to_ext_stack(var_struct *p_sci, const int &v)
{
  *(p_sci->p_external.p_int) = v;
}

void pop_from_ext_stack(int &v, const var_struct *p_sci)
{
  v = *(p_sci->p_external.p_int);
}


void push_to_ext_stack(var_struct *p_sci, const bool &v)
{
  *(p_sci->p_external.p_bool) = v;
}

void pop_from_ext_stack(bool &v, const var_struct *p_sci)
{
#pragma warning( suppress : 4800 )
  v = *(p_sci->p_external.p_bool);
}


void operator <=(vec &v, var_struct *p_sci)
{
  int i;

  for(i = 0; i < v.size(); i++)
  {
    v[i] = *(p_sci->p_external.p_double + i);
  }
}

void operator <=(var_struct *p_sci, const vec &v)
{
  int i;

  for(i = 0; i < v.size(); i++)
  {
    *(p_sci->p_external.p_double + i) = v[i];
  }
}

//----------------------------------------------------
void operator <=(cvec &cv, var_struct *p_sci)
{
  int i;

  double re, im;
  for(i = 0; i < cv.size(); i++)
  {
    re = *(p_sci->p_external.re_im.p_re + i);
    im = *(p_sci->p_external.re_im.p_im + i);
    cv[i] = std::complex<double>(re, im);
  }
}

void operator <=(var_struct *p_sci, const cvec &cv)
{
  int i;

  for(i = 0; i < cv.size(); i++)
  {
    *(p_sci->p_external.re_im.p_re + i) = cv[i].real();
    *(p_sci->p_external.re_im.p_im + i) = cv[i].imag();
  }
}

//----------------------------------------------------
void operator <=(ivec &v, var_struct *p_sci)
{
  int i;
  for(i = 0; i < v.size(); i++)
  {
    v[i] = *(p_sci->p_external.p_int + i);
  }
}

void operator <=(var_struct *p_sci, const ivec &v)
{
  int i;
  for(i = 0; i < v.size(); i++)
  {
    *(p_sci->p_external.p_int + i) = v[i];
  }
}

//----------------------------------------------------
void operator <=(bvec &b, var_struct *p_sci)
{
  int i;
  for(i = 0; i < b.size(); i++)
  {
    b[i] = *(p_sci->p_external.p_bool + i);
  }
}

void operator <=(var_struct *p_sci, const bvec &b)
{
  int i;
  for(i = 0; i < b.size(); i++)
  {
    *(p_sci->p_external.p_bool + i) = b[i];
  }
}
//----------------------------------------------------
void operator <=(mat &m, var_struct *p_sci)
{
  const int Nrow = m.rows();
  const int Ncol = m.cols();
  int i, j;
  for(i = 0; i < Nrow; i++)
  {
    for(j = 0; j < Ncol; j++)
    {
      m(i, j) = *(p_sci->p_external.p_double + F_OFFSET(i, j, Nrow, Ncol)); // transpose (sci) FORTRAN->C (mat)
    }
  }
}

void operator <=(var_struct *p_sci, const mat &m)
{
  const int Nrow = m.rows();
  const int Ncol = m.cols();
  int i, j;
  for(i = 0; i < Nrow; i++)
  {
    for(j = 0; j < Ncol; j++)
    {
      *(p_sci->p_external.p_double + F_OFFSET(i, j, Nrow, Ncol)) = m(i, j); // transpose (mat) C->FORTRAN (sci)
    }
  }
}

//----------------------------------------------------
void operator <=(cmat &cm, var_struct *p_sci)
{
  const int Nrow = cm.rows();
  const int Ncol = cm.cols();
  int i, j;
  double re, im;
  for(i = 0; i < Nrow; i++)
  {
    for(j = 0; j < Ncol; j++)
    {
      re = *(p_sci->p_external.re_im.p_re + F_OFFSET(i, j, Nrow, Ncol)); // transpose (sci) FORTRAN->C (mat)
      im = *(p_sci->p_external.re_im.p_im + F_OFFSET(i, j, Nrow, Ncol)); // transpose (sci) FORTRAN->C (mat)
      cm(i, j) = std::complex<double>(re, im);
    }
  }
}

void operator <=(var_struct *p_sci, const cmat &cm)
{
  const int Nrow = cm.rows();
  const int Ncol = cm.cols();
  int i, j;
  for(i = 0; i < Nrow; i++)
  {
    for(j = 0; j < Ncol; j++)
    {
      *(p_sci->p_external.re_im.p_re + F_OFFSET(i, j, Nrow, Ncol)) = cm(i, j).real(); // transpose (mat) C->FORTRAN (sci)
      *(p_sci->p_external.re_im.p_im + F_OFFSET(i, j, Nrow, Ncol)) = cm(i, j).imag(); // transpose (mat) C->FORTRAN (sci)
    }
  }
}

//----------------------------------------------------
void operator <=(imat &m, var_struct *p_sci)
{
  const int Nrow = m.rows();
  const int Ncol = m.cols();
  int i, j;
  for(i = 0; i < Nrow; i++)
  {
    for(j = 0; j < Ncol; j++)
    {
      m(i, j) = *(p_sci->p_external.p_int + F_OFFSET(i, j, Nrow, Ncol)); // transpose (sci) FORTRAN->C (mat)
    }
  }
}

void operator <=(var_struct *p_sci, const imat &m)
{
  const int Nrow = m.rows();
  const int Ncol = m.cols();
  int i, j;

  for(i = 0; i < Nrow; i++)
  {
    for(j = 0; j < Ncol; j++)
    {
      *(p_sci->p_external.p_int + F_OFFSET(i, j, Nrow, Ncol)) = m(i, j); // transpose (sci) FORTRAN->C (mat)
    }
  }
}

//----------------------------------------------------
void operator <=(bmat &m, var_struct *p_sci)
{
  const int Nrow = m.rows();
  const int Ncol = m.cols();
  int i, j;
  for(i = 0; i < Nrow; i++)
  {
    for(j = 0; j < Ncol; j++)
    {
      m(i, j) = *(p_sci->p_external.p_bool + F_OFFSET(i, j, Nrow, Ncol)); // transpose (sci) FORTRAN-> (itpp) C
    }
  }
}

void operator <=(var_struct *p_sci, const bmat &m)
{
  const int Nrow = m.rows();
  const int Ncol = m.cols();
  int i, j;

  for(i = 0; i < Nrow; i++)
  {
    for(j = 0; j < Ncol; j++)
    {
      *(p_sci->p_external.p_bool + F_OFFSET(i, j, Nrow, Ncol)) = m(i, j) ; // transpose (itpp) C -> (sci) FORTRAN
    }
  }
}


