/*xxx
* \brief - printf for py Variables as defined by scipy_var struct
* \author maki
*/


#ifdef __cplusplus
extern "C" {
#endif

#include "scipy_debug.h"

  void printf_scipy_double(scipy_var_t *p_scipy_var)
  {
    printf("[printf_scipy_double]:  pyVar = %f \n", *((double *)p_scipy_var->p_pyVar));
  }


  void printf_scipy_complex(scipy_var_t *p_scipy_var)
  {
    printf("[printf_scipy_complex]:  pyVar = %f + j%f \n", ((py_complex_var_t *)p_scipy_var->p_pyVar)->re, ((py_complex_var_t *)p_scipy_var->p_pyVar)->im);
  }


  void printf_scipy_int(scipy_var_t *p_scipy_var)
  {
    printf("[printf_scipy_int]:  pyVar = %d \n", *((int *)p_scipy_var->p_pyVar));
  }


  void printf_scipy_bool(scipy_var_t *p_scipy_var)
  {
    printf("[printf_scipy_bool]:  pyVar = %d \n", *((bool *)p_scipy_var->p_pyVar));
  }


  void printf_scipy_vec(scipy_var_t *p_scipy_var)
  {
    int i;
    printf("[printf_py_vec] p_py[] = \n [");
    for(i = 0; i < p_scipy_var->nRows; i++)
    {
      if(i)
      {
        printf(", ");
      }
      printf("%f", *(((double *)p_scipy_var->p_pyVar) + i));
    }
    printf("]\n");
  }

  void printf_scipy_mat(scipy_var_t *p_scipy_var)
  {
    int i, j;
    printf("[printf_py_mat] p_py[] = [\n[");

    for(i = 0; i < p_scipy_var->nRows; i++)
    {
      if(i)
      {
        printf("];\n[");
      }
      for(j = 0; j < p_scipy_var->nCols; j++)
      {
        if(j)
        {
          printf(", ");
        }
        printf("%f", ((double *)p_scipy_var->p_pyVar)[i * (p_scipy_var->nCols) + j]);
      }
    }
    printf("];]\n");

  }


  void printf_scipy_cvec(scipy_var_t *p_scipy_var)
  {
    int i;
    printf("[printf_py_cvec] p_py[] = \n [");
    for(i = 0; i < p_scipy_var->nRows; i++)
    {
      if(i)
      {
        printf(", ");
      }
      printf("%f + j%f", (((py_complex_var_t *)p_scipy_var->p_pyVar) + i)->re, (((py_complex_var_t *)p_scipy_var->p_pyVar) + i)->im);

    }
    printf("]\n");
  }


  void printf_scipy_cmat(scipy_var_t *p_scipy_var)
  {
    int i, j;
    printf("[printf_py_cmat] p_py[] = [\n[");

    for(i = 0; i < p_scipy_var->nRows; i++)
    {
      if(i)
      {
        printf("];\n[");
      }
      for(j = 0; j < p_scipy_var->nCols; j++)
      {
        if(j)
        {
          printf(", ");
        }
        printf("%f + j%f", (&((py_complex_var_t *)p_scipy_var->p_pyVar)[i * (p_scipy_var->nCols) + j])->re,
               (&((py_complex_var_t *)p_scipy_var->p_pyVar)[i * (p_scipy_var->nCols) + j])->im);
      }
    }
    printf("];]\n");

  }


  void printf_scipy_ivec(scipy_var_t *p_scipy_var)
  {
    int i;
    printf("[printf_py_ivec] p_py[] = \n [");
    for(i = 0; i < p_scipy_var->nRows; i++)
    {
      if(i)
      {
        printf(", ");
      }
      printf("%d", *(((int *)p_scipy_var->p_pyVar) + i));
    }
    printf("]\n");
  }

  void printf_scipy_imat(scipy_var_t *p_scipy_var)
  {
    int i, j;
    printf("[printf_py_imat] p_py[] = [\n[");

    for(i = 0; i < p_scipy_var->nRows; i++)
    {
      if(i)
      {
        printf("];\n[");
      }
      for(j = 0; j < p_scipy_var->nCols; j++)
      {
        if(j)
        {
          printf(", ");
        }
        printf("%d", ((int *)p_scipy_var->p_pyVar)[i * (p_scipy_var->nCols) + j]);
      }
    }
    printf("];]\n");

  }


  void printf_scipy_bmat(scipy_var_t *p_scipy_var)
  {
    int i, j;
    printf("[printf_py_bmat] p_py[] = [\n[");

    for(i = 0; i < p_scipy_var->nRows; i++)
    {
      if(i)
      {
        printf("];\n[");
      }
      for(j = 0; j < p_scipy_var->nCols; j++)
      {
        if(j)
        {
          printf(", ");
        }
        printf("%d", ((bool *)p_scipy_var->p_pyVar)[i * (p_scipy_var->nCols) + j]);
      }
    }
    printf("];]\n");

  }

  void printf_scipy_bvec(scipy_var_t *p_scipy_var)
  {
    int i;
    printf("[printf_py_bvec] p_py[] = \n [");
    for(i = 0; i < p_scipy_var->nRows; i++)
    {
      if(i)
      {
        printf(", ");
      }
      printf("%d", *(((bool *)p_scipy_var->p_pyVar) + i));
    }
    printf("]\n");
  }

#ifdef __cplusplus
}
#endif
