/*xxx
* \brief - python ctypes functions exported in dll
* \author maki
*
*/

#ifdef __cplusplus
extern "C" {
#endif

#include <stddef.h>
#include <stdint.h>
#include <stdlib.h>
#include <string.h>

#include "sci\_sci_if.h"
#include "sci\_sci_enum_def.h"
#include "sci\_sci_types.h"

#include "_sci_if_var_struct.h"

#include "scipy_debug.h"
#include "scipy_types.h"

#include "__debug.h"

// set by _sci_if error variables
  static int scipy_err = SCIPY_ERR_NONE;
  static int scipy_info = 0;
  static char scipy_err_msg[SCI_ERR_MSG_LEN];

  py_allocator_t          p_py_allocator = NULL;
  py_error_handler_t      p_py_error_handler = NULL;


  void sci_if_err_set(int e)
  {
    scipy_err = e;
  }

  void sci_if_err_msg_set(const char *p_msg)
  {
    strcpy_s(scipy_err_msg, SCI_ERR_MSG_LEN, p_msg);
  }

  void sci_if_info_set(int i)
  {
    scipy_info = i;
  }

  void  scipy_error_callback()
  {
    if(p_py_error_handler)
      (*p_py_error_handler)(scipy_err_msg, scipy_info, scipy_err);
    abort();
  }

  void scipy_if_error_handler(const char *p_err_msg, int info, int err)
  {
    sci_if_err_set(err);
    sci_if_info_set(info);
    sci_if_err_msg_set(p_err_msg);
    scipy_error_callback();
  }

  int scipy_init(py_allocator_t p_allocator, py_error_handler_t p_error_handler)
  {
    int err_code = 0;

    if(p_allocator && p_error_handler)
    {

      p_py_allocator = p_allocator;
      p_py_error_handler = p_error_handler;
      debug_3("DBG3 [scipy_init] p_allocator = 0x%08p p_error_handler = 0x%08p \n", p_allocator, p_error_handler);
    }
    else
    {
      printf("[scipy_init] :: null pointer exception :: p_allocator = 0x%08p p_error_handler = 0x%08p \n", p_allocator, p_error_handler);
      err_code = -1; // NULL pointer
      abort();
    }
    return err_code = -1;
  }

  void* scipy_alloc_callback(scipy_var_t scipy_var)
  {
    void *ptr;

    if(p_py_allocator)
    {
      ptr = (*p_py_allocator)(scipy_var);
      if(ptr)
      {
        return ptr;
      }
      else
      {
        scipy_if_error_handler("[scipy_alloc_callback] :: null pointer exception ::", 0, SCIPY_ERR_NULL_POINTER);
      }
    }
    else
    {
      scipy_if_error_handler("[scipy_alloc_callback] :: null callback exception ::", 0, SCIPY_ERR_NULL_POINTER);
    }

    return NULL;
  }

  struct var_struct  scipy_to_var_struct(scipy_var_t *p_scipy_var)
  {
    var_struct_t v;

    v.cols = p_scipy_var->nCols;
    v.rows = p_scipy_var->nRows;
    v.p_var = p_scipy_var->p_cVar;
    v.sci_type = p_scipy_var->sciType;
    switch(v.sci_type)
    {
      case SCI_TYPE_DOUBLE:
      case SCI_TYPE_VEC:
      case SCI_TYPE_MAT:
        v.p_external.p_double = (double *)p_scipy_var->p_pyVar;
        break;
      case SCI_TYPE_COMPLEX:
      case SCI_TYPE_CVEC:
      case SCI_TYPE_CMAT:
        v.p_external.p_complex = p_scipy_var->p_pyVar;
        break;
      case SCI_TYPE_INT:
      case SCI_TYPE_IVEC:
      case SCI_TYPE_IMAT:
        v.p_external.p_int = (int *)p_scipy_var->p_pyVar;
        break;
      case SCI_TYPE_BOOL:
      case SCI_TYPE_BVEC:
      case SCI_TYPE_BMAT:
        v.p_external.p_bool = (bool *)p_scipy_var->p_pyVar;
        break;
      default:
        scipy_if_error_handler("[scipy_to_var_struct] :: unknown type exception:: sci_type = ", v.sci_type, SCIPY_ERR_BAD_VAR_TYPE);
        break;
    }
    return v;
  }

  void  set_p_pyVar(var_struct_t *p_v_s, scipy_var_t *p_scipy_var)
  {
    switch(p_v_s->sci_type)
    {
      case SCI_TYPE_DOUBLE:
      case SCI_TYPE_VEC:
      case SCI_TYPE_MAT:
        p_v_s->p_external.p_double = (double *)p_scipy_var->p_pyVar;
        break;
      case SCI_TYPE_COMPLEX:
      case SCI_TYPE_CVEC:
      case SCI_TYPE_CMAT:
        p_v_s->p_external.p_complex = p_scipy_var->p_pyVar;
        break;
      case SCI_TYPE_INT:
      case SCI_TYPE_IVEC:
      case SCI_TYPE_IMAT:
        p_v_s->p_external.p_int = (int *)p_scipy_var->p_pyVar;
        break;
      case SCI_TYPE_BOOL:
      case SCI_TYPE_BVEC:
      case SCI_TYPE_BMAT:
        p_v_s->p_external.p_bool = (bool *)p_scipy_var->p_pyVar;
        break;
      default:
        scipy_if_error_handler("[set_p_pyVar] ::unknow type exception:: sci_type = ", p_v_s->sci_type, SCIPY_ERR_BAD_VAR_TYPE);
        break;
    }
  }

  scipy_var_t  var_struct_to_scipy(var_struct_t *p_v_s)
  {
    scipy_var_t v;

    v.nCols = p_v_s->cols;
    v.nRows = p_v_s->rows;
    v.sciType = p_v_s->sci_type;
    v.p_cVar = p_v_s->p_var;

    switch(v.sciType)
    {
      case SCI_TYPE_DOUBLE:
      case SCI_TYPE_VEC:
      case SCI_TYPE_MAT:
        v.p_pyVar = (void *)p_v_s->p_external.p_double;
        break;
      case SCI_TYPE_COMPLEX:
      case SCI_TYPE_CVEC:
      case SCI_TYPE_CMAT:
        v.p_pyVar = (void *)p_v_s->p_external.p_complex;
        break;
      case SCI_TYPE_INT:
      case SCI_TYPE_IVEC:
      case SCI_TYPE_IMAT:
        v.p_pyVar = (void *)p_v_s->p_external.p_int;
        break;
      case SCI_TYPE_BOOL:
      case SCI_TYPE_BVEC:
      case SCI_TYPE_BMAT:
        v.p_pyVar = (void *)p_v_s->p_external.p_bool;
        break;
      default:
        scipy_if_error_handler("[var_struct_to_scipy] ::unknown var type exception:: sci_type=", v.sciType, SCIPY_ERR_BAD_VAR_TYPE);
        break;
    }
    return v;

  }

  /*
   * \brief C interface to sci_create
   *
   * Example: p_fir1 = sci_create(SCI_FIR);
   * input1 SCI_TYPE (standard enum type == double)
   * output pointer to created SCI_TYPE object
   */

  void * scipy_create(int sci_type)
  {
    void *p_sci;


    debug_1("[scipy_create] ..................... \r\n");
    p_sci = sci_if_create(sci_type);
    debug_1("sci_type = %d p_sci = 0x%X \r\n", sci_type, p_sci);
    debug_1("[scipy_create] +++++++++++++++++++++ \r\n");

    return p_sci;
  }

  /*
   * \brief C interface to sci_set
   *
   * Example: sci_set(p_fir1,SCI_TAPS,c0);
   * input1 p_fir1= pointer to the instance SCI_TYPE object
   * input2 SCI_TAPS = enum type - scilab default type - double
   * input3 c0 = variable - might be matrix (scalar) booleans, integers, doubles, complexes
   * output NONE
   */

  void scipy_set(void *p_sci, int param, scipy_var_t *p_scipy_x)
  {
    var_struct_t s_x;

    debug_3("[scipy_set] ..................... \r\n");

    if(p_sci)
    {
      scipy_err = 0;
      s_x = scipy_to_var_struct(p_scipy_x);
      sci_if_set(p_sci, param, &s_x);
      if(scipy_err)
      {
        printf("[scipy_set] ::error in sci_if_set()::  %s  info=%d err=%d  \n", scipy_err_msg, scipy_info, scipy_err);
        scipy_error_callback();
      }
    }
    else
    {
      scipy_if_error_handler("[scipy_set] :: null pointer exception ::", 0, SCIPY_ERR_NULL_POINTER);
    }
    debug_3("[scipy_set] +++++++++++++++++++++ \r\n");
  }

  /*
   * \brief C interface to sci_get
   *
   * Example: c0 = sci_get(p_fir1,SCI_TAPS);
   * input1 p_fir1 = pointer to the instance of SCI_TYPE object
   * input2 SCI_TAPS = enum type - scilab default type - double
   * output c0 = variable - might be matrix (scalar) of booleans, integers, doubles, complexes
   */

  void scipy_get(void *p_sci, int param)
  {

    var_struct_t s_y;
    scipy_var_t scipy_y;

    debug_3("[scipy_get] ..................... \r\n");
    if(p_sci)
    {
      scipy_err = 0;
      s_y = sci_if_get(p_sci, param);
      if(scipy_err)
      {
        printf("[scipy_get] ::error in sci_if_get()::  %s  info=%d err=%d  \n", scipy_err_msg, scipy_info, scipy_err);
        scipy_error_callback();
      }
      // format scipy variable
      scipy_y = var_struct_to_scipy(&s_y);
      // allocate scipy variable
      scipy_y.p_pyVar = scipy_alloc_callback(scipy_y);
      // pass pointer from scipy to var_struct
      set_p_pyVar(&s_y, &scipy_y);
      // copy values from c-heap into scilab memory
      sci_if_copy_var(&s_y);
      // remove variable from c-heap
      sci_if_delete_var(&s_y);
    }
    else
    {
      scipy_if_error_handler("[scipy_get] :: null pointer exception ::", 0, SCIPY_ERR_NULL_POINTER);
    }
    debug_3("[scipy_get] +++++++++++++++++++++ \r\n");
  }

  /*
   * \brief C interface to sci_exec
   *
   * Example: sci_exec(p_fir1,SCI_RESET);
   * input1 p_fir1 = pointer to the instance of SCI_TYPE object
   * input2 SCI_RESET = type of command
   * output NONE
   */

  void scipy_exec(void *p_sci, int param)
  {

    debug_3("[scipy_exec] ..................... \r\n");
    if(p_sci)
    {
      scipy_err = 0;
      sci_if_exec(p_sci, param);
      if(scipy_err)
      {
        printf("[scipy_exec] ::error in sci_if_exec()::  %s  info=%d err=%d  \n", scipy_err_msg, scipy_info, scipy_err);
        scipy_error_callback();
      }
    }
    else
    {
      scipy_if_error_handler("[scipy_exec] :: null pointer exception ::", 0, SCIPY_ERR_NULL_POINTER);
    }
    debug_3("[scipy_exec] +++++++++++++++++++++ \r\n");
  }

  /*
   * \brief C interface to sci_gen
   *
   * Example: y = sci_gen(p_mod,ce);
   * input1 p_mod = pointer to the instance of SCI_TYPE object
   * input2 ce = boolean
   * output y  = variable of any type
   */

  void scipy_gen(void *p_sci, scipy_var_t *p_scipy_ce)
  {

    scipy_var_t scipy_y;

    var_struct_t s_y;
    var_struct_t s_ce;

    debug_3("[scipy_gen] ..................... \r\n");
    if(p_sci)
    {
      scipy_err = 0;
      s_ce = scipy_to_var_struct(p_scipy_ce);
      if(!((s_ce.sci_type == SCI_TYPE_BOOL) || (s_ce.sci_type == SCI_TYPE_BVEC) || (s_ce.sci_type == SCI_TYPE_BMAT)))
      {
        scipy_if_error_handler("[scipy_gen] ::not valid ce exception:: sci_type=", s_ce.sci_type, SCIPY_ERR_BAD_CE_TYPE);
      }
      else
      {
        s_y = sci_if_gen(p_sci, &s_ce);
        if(scipy_err)
        {
          printf("[scipy_gen] ::error in sci_if_gen()::  %s  info=%d err=%d  \n", scipy_err_msg, scipy_info, scipy_err);
          scipy_error_callback();
        }
        // format scipy variable
        scipy_y = var_struct_to_scipy(&s_y);
        // allocate scipy variable
        scipy_y.p_pyVar = scipy_alloc_callback(scipy_y);
        // pass pointer from scipy to var_struct
        set_p_pyVar(&s_y, &scipy_y);
        // copy values from c-heap into scilab memory
        sci_if_copy_var(&s_y);
        // remove variable from c-heap
        sci_if_delete_var(&s_y);
      }
    }
    else
    {
      scipy_if_error_handler("[scipy_gen] :: null pointer exception ::", 0, SCIPY_ERR_NULL_POINTER);
    }
    debug_3("[scipy_gen] +++++++++++++++++++++ \r\n");
  }



  /*
   * \brief C interface to sci_proc
   *
   * Example: y = sci_proc(p_fir1,ce,x);
   * input1 p_fir1 = pointer to the instance of SCI_TYPE object
   * input2 ce - boolean
   * input2 x  - any variable
   * output y  - any variable
   */
  void scipy_proc(void *p_sci, scipy_var_t *p_scipy_ce, scipy_var_t *p_scipy_x)
  {

    scipy_var_t scipy_y;

    var_struct_t s_ce;
    var_struct_t s_x;
    var_struct_t s_y;

    debug_3("[scipy_proc] ..................... \r\n");
    if(p_sci)
    {
      scipy_err = 0;
      s_ce = scipy_to_var_struct(p_scipy_ce);
      if(!((s_ce.sci_type == SCI_TYPE_BOOL) || (s_ce.sci_type == SCI_TYPE_BVEC) || (s_ce.sci_type == SCI_TYPE_BMAT)))
      {
        scipy_if_error_handler("[scipy_gen] ::not valid ce exception:: sci_type=", s_ce.sci_type, SCIPY_ERR_BAD_CE_TYPE);
      }
      else
      {
        s_x = scipy_to_var_struct(p_scipy_x);
        s_y = sci_if_proc(p_sci, &s_ce, &s_x);
        if(scipy_err)
        {
          printf("[scipy_proc] ::error in sci_if_proc()::  %s  info=%d err=%d \n", scipy_err_msg, scipy_info, scipy_err);
          scipy_error_callback();
        }
        else
        {
          // format scipy variable
          scipy_y = var_struct_to_scipy(&s_y);
          // allocate scipy variable
          scipy_y.p_pyVar = scipy_alloc_callback(scipy_y);
          // pass pointer from scipy to var_struct
          set_p_pyVar(&s_y, &scipy_y);
          // copy values from c-heap into scilab memory
          sci_if_copy_var(&s_y);
          // remove variable from c-heap
          sci_if_delete_var(&s_y);
        }
      }
    }
    else
    {
      scipy_if_error_handler("[scipy_proc] :: null pointer exception ::", 0, SCIPY_ERR_NULL_POINTER);
    }

    debug_3("[scipy_proc] +++++++++++++++++++++ \r\n");

  }

  /*
   * \brief C interface to scilab sci_destroy
   *
   * Example: sci_destroy(p_fir1);
   * input SCI_FIR = type of SCI_TYPE object
   * output void
   */
  void scipy_destroy(void *p_sci)
  {

    debug_1("[scipy_destroy] ..................... \r\n");
    if(p_sci)
    {
      scipy_err = 0;
      sci_if_destroy(p_sci);
      if(scipy_err)
      {
        printf("[scipy_destroy] ::error in sci_if_destroy()::  %s  info=%d err=%d  \n", scipy_err_msg, scipy_info, scipy_err);
        scipy_error_callback();
      }
    }
    else
    {
      scipy_if_error_handler("[scipy_destroy] :: null pointer exception ::", 0, SCIPY_ERR_NULL_POINTER);
    }
    debug_1("[scipy_destroy] +++++++++++++++++++++ \r\n");
  }


#ifdef __cplusplus
}
#endif

