/*xxx
* \brief - operational types
* \author maki
*/

#ifndef SCIPY_TYPES_HPP
#define SCIPY_TYPES_HPP

// #include "stdbool.h" // only in msvc2013

#ifndef _STDBOOL
#define _STDBOOL

#define __bool_true_false_are_defined	1

#ifndef __cplusplus

#define bool	char
#define false	0
#define true	1

#endif /* __cplusplus */

#endif /* _STDBOOL */



typedef struct  
{
    void * p_pyVar;
    int nRows;					    // rows in matrix,  for scalar: 1 
    int nCols;					    // cols in matrix,  for scalar and vector: 1
    int sciType;
    void *p_cVar;			        // pointer to matching variable object on c++ heap
} scipy_var_t;


// SCI error codes
enum scipy_err {
    SCIPY_ERR_NONE = 0,
    SCIPY_ERR_NULL_POINTER = 1,
    SCIPY_ERR_BAD_VAR_TYPE = 2,
    SCIPY_ERR_BAD_CE_TYPE = 3
};


typedef struct
{
    double re;
    double im;					    
} py_complex_var_t;

typedef void* (*py_allocator_t)(scipy_var_t scipy_var);
typedef void  (*py_error_handler_t)(char *p_msg, int arg1, int arg2);

#endif



