/*xxx
 * \brief - SIM::amp - gain block
 * \author maki
 */

#include "sim\sim_amp.hpp"
#include "sim\_sim_exception.hpp"
#include "__debug_level.h"
#include "debug.hpp"

namespace SIM
{

void amp::set_gain(double g)
{
  gain = g;
}

void amp::set_offset(double o)
{
  offset = o;
}

void amp::set_output(double yout)
{
  y0 = yout;
}

double amp::get_gain(void)
{
  return (gain);
}

double amp::get_offset(void)
{
  return (offset);
}

double amp::get_output(void)
{
  return (y0);
}

vec amp::process(const bvec &ce, const vec &x)
{
  vec y;
  int N;

  debug(3) << " amp::process ce = " << ce << endl;
  debug(3) << " amp::process  x = " << x << endl;

  N = ce.length();
  if(x.length() != N)
  {
    throw sim_exception("amp::process - ce.size <> x.size()", x.length());
  }
  
  y.set_length(N);

  for(int i = 0; i < N; i++)
  {
    if(ce[i])
    {
      y0 = gain * x[i] + offset;
    }
    y[i] = y0;
  }
  
  debug(3) << " amp::process y = " << y << endl;
  return (y);
}

} // namespace SIM