/*xxx
 * \brief - SIM::amp_x - complex gain block
 * \author maki
 */

#include "sim\sim_amp_x.hpp"
#include "sim\_sim_exception.hpp"
#include "__debug_level.h"
#include "debug.hpp"

namespace SIM
{

void amp_x::set_gain(complexd g)
{
  gain = g;
}

void amp_x::set_offset(complexd o)
{
  offset = o;
}

void amp_x::set_output(complexd yout)
{
  y0 = yout;
}

complexd amp_x::get_gain(void)
{
  return (gain);
}

complexd amp_x::get_offset(void)
{
  return (offset);
}

complexd amp_x::get_output(void)
{
  return (y0);
}

cvec amp_x::process(const bvec &ce, const cvec &x)
{
  cvec y;
  int N;

  debug(3) << " amp_x::process ce = " << ce << endl;
  debug(3) << " amp_x::process  x = " << x << endl;

  N = ce.length();
  if(x.length() != N)
  {
    throw sim_exception("amp_x::process - ce.size <> x.size()", x.length());
  }

  y.set_length(N);

  for(int i = 0; i < N; i++)
  {
    if(ce[i])
    {
      y0 = gain * x[i] + offset;
    }
    y[i] = y0;
  }

  debug(3) << " amp_x::process  y = " << y << endl;
  return (y);
}

} // namespace SIM