/*xxx
* \brief - SIM::ap2iq  - amplitude/phase to IQ
* \author maki
*/

#include "sim\sim_ap2iq.hpp"
#include "sim\_sim_exception.hpp"
#include "__debug_level.h"
#include "debug.hpp"

namespace SIM
{

void ap2iq::set_output(complexd yout)
{
  y0 = yout;
}

complexd ap2iq::get_output(void)
{
  return (y0);
}

cvec ap2iq::process(const bvec &ce, const mat &x)
{
  cvec y;
  int N;

  debug(3) << "ap2iq::process ce = " << ce << endl;
  debug(3) << "ap2iq::process  x = " << x << endl;

  N = ce.length();
  if(x.rows() != N)
  {
    throw sim_exception("ap2iq::process - ce.size <> x.rows()", x.rows());
  }

  if(x.cols() != 2)
  {
    throw sim_exception("ap2iq::process - x.cols <> 2", x.cols());
  }

  y.set_length(N);
  for(int i = 0; i < N; i++)
  {
    if(ce[i])
    {
      y0 = std::polar(x(i, 0), x(i, 1));
    }
    y[i] = y0;
  }

  debug(3) << "ap2iq::process  y = " << y << endl;
  return (y);
}

} // namespace SIM