/*xxx
* \brief - SIM::bin2int - binary to integer converter
* \author maki
*/


#include "sim\sim_bin2int.hpp"

#include "sim\_sim_exception.hpp"
#include "__debug_level.h"
#include "debug.hpp"


namespace SIM
{

void bin2int::set_symbol_size(int W)
{
  if(W > 0)
  {
    symbol_size = W;
  }
  else
  {
    throw sim_exception("bin2int.set_symbol_size - not in range [ >0 ]", W);
  }
}

int bin2int::get_symbol_size()
{
  return symbol_size;
}


void bin2int::set_output(int yout)
{
  y0 = yout;
}

int bin2int::get_output()
{
  return y0;
}

void bin2int::set_msb_flag(bool msb)
{
  msb_first = msb;
}

bool bin2int::get_msb_flag()
{
  return msb_first;
}


ivec bin2int::process(const bvec &ce, const bmat &x)
{
  ivec y;
  int N;

  debug(3) << "bin2int::process() ce = " << ce << endl;
  debug(3) << "bin2int::process()  x = " << x << endl;
  N = ce.length();
  if(x.rows() != N)
  {
    throw sim_exception("bin2int::process - ce.size <> x.rows()", x.rows());
  }
  if(x.cols() != symbol_size)
  {
    throw sim_exception("bin2int::process - x.cols <> symbol_size", x.cols());
  }
  y.set_length(N);
  for(int i = 0; i < N; i++)
  {
    if(bool(ce[i]))
    {
      y0 = bin2dec(x.get_row(i), msb_first);
    }
    y[i] = y0;
  }
  debug(3)  << "bin2int::process() y = " << y << endl;
  return (y);
}

} // namespace SIM