/*xxx
* \brief - SIM::binbuff - binary circular buffer derived from itpp::Circular_Buffer<bin>
* \author maki
*/

#include "sim\sim_binbuff.hpp"
#include "sim\_sim_exception.hpp"
#include "__debug_level.h"
#include "debug.hpp"

namespace SIM
{

void binbuff::set_size(int m)
{
  if(m <= 0)
  {
    throw sim_exception("binbuff::set_size - bad size", m);
  }
  itpp::Circular_Buffer<bin>::set_size(m);
}

void binbuff::set_symbol_size(int w)
{
  if(w <= 0)
  {
    throw sim_exception("binbuff::set_symbol_size - bad size", w);
  }
  symbol_size = w;
  y0.set_length(w);
  y0 = to_bvec(to_ivec(zeros(symbol_size)));
}

void binbuff::set_output(bvec yout)
{
  if(yout.size() != symbol_size)
  {
    throw sim_exception("binbuff::set_output yout.size <> symbol_size ", symbol_size);
  }
  y0 = yout;
}

int binbuff::get_size(void)
{
  return (size());
}

int binbuff::get_symbol_size(void)
{
  return (symbol_size);
}

bvec binbuff::get_output(void)
{
  return (y0);
}

bmat binbuff::generate(const bvec &ce)
{
  bmat y;
  int K, i;

  debug(3) << "binbuff::generate ce = " << ce << endl;

  K = ce.length();
  y.set_size(K, symbol_size);
  
  for(i = 0; i < K; i++)
  {
    if(bool(ce(i)))
    {
      try
      {
        get(y0, symbol_size);
        put(y0);
      }
      catch(...)
      {
        throw sim_exception(" binbuff::generate - error for get()/put()");
      }
    }
    y.set_row(i, y0);
  }
  
  debug(3) << "binbuff::generate  y =" << y << endl;
  return (y);
}

// ceio [cei|ceo]
bmat binbuff::process(const bmat &ceio, const bmat &x)
{
  bmat y;
  int K, i;

  debug(3) << "binbuff::process ceio = " << ceio << endl;
  debug(3) << "binbuff::process    x = " << x << endl;

  if(ceio.cols() != 2)
  {
    throw sim_exception("binbuff::process - ceio.cols() <> 2 ", ceio.cols());
  }
  if(x.rows() != ceio.rows())
  {
    throw sim_exception("binbuff::process - x.rows() <> ceio.rows() ", x.rows());
  }

  K = ceio.rows();
  y.set_size(K, symbol_size);

  for(i = 0; i < K; i++)
  {
    // cei - input sample to cb
    if(ceio(i, 0))
    {
      put(x.get_row(i));
    }
    // ceo - get sample from cb
    if(ceio(i, 1))
    {
      try
      {
        get(y0, symbol_size);
      }
      catch(...)
      {
        throw sim_exception(" binbuff::process - error for get()");
      }
    }
    y.set_row(i, y0);
  }

  debug(3) << "binbuff::process    y = " << y << endl;
  return (y);
}

} // namespace SIM