/*xxx
* \brief - SIM::casdec_x - cascade of /2 complex decimators
* \author maki
*/

#include "sim\sim_casdec_x.hpp"
#include "sim\_sim_exception.hpp"
#include "__debug_level.h"
#include "debug.hpp"

namespace SIM
{

void dec_cell_x::set_taps(cvec c)
{
  f_x.set_taps(c);
};

void dec_cell_x::reset()
{
  cnt.reset();
  f_x.reset();
};


cmat dec_cell_x::process(const bvec &ce, const cvec &x)
{
  cmat y;
  cvec yv;
  bvec yb;
  int L;

  debug(3) << "dec_cell_x::process ce = " << ce << endl;
  debug(3) << "dec_cell_x::process  x = " << x << endl;

  L = ce.length();
  y.set_size(L, 2);
  yv.set_length(L);
  yb.set_length(L);
  yv = f_x.process(ce, x);
  yb = cnt.generate(ce);
  y.set_col(0, yv);
  y.set_col(1, to_cvec(to_vec(yb), zeros(yb.length())));

  debug(3) << "dec_cell_x::process  y = " << y << endl;

  return (y);
}


void casdec_x::set_decimator_order(int n)
{

  N = levels2bits(n);  // N=log2(n) 
  if ((pow2i(N) == n))
  {
    dec_cell_vec.resize(N);
    output_cell_index = N;
  }
  else
  {
    throw sim_exception("casdec_x.set_decimator_order:: order is not a power of 2", n);
  }
};

void casdec_x::set_decimator_rate(int r)
{
  int n = levels2bits(r);  // n=log2(r) 
  if ((pow2i(n) == r))
  {
    if ((n <= N) && (n > 0))
    {
      output_cell_index = n;
    }
    else
    {
      throw sim_exception("casdec_x.set_decimator_rate:: rate must be in range [2..2^N]", n);
    }
  }
  else
  {
    throw sim_exception("casdec_x.set_decimator_rate:: rate is not a power of 2", r);
  }

};


void casdec_x::set_taps(cvec c)
{
  for(int i = 0; i < N; i++) dec_cell_vec[i].set_taps(c);
};

void casdec_x::reset()
{
  for(int i = 0; i < N; i++) dec_cell_vec[i].reset();
};


cmat casdec_x::process(const bvec &ce, const cvec &x)
{
  cmat y;
  bvec ce_cas;
  cvec x_cas;
  int L;

  debug(3) << "casdec_x::process ce = " << ce << endl;
  debug(3) << "casdec_x::process  x = " << x << endl;

  L = ce.length();
  if(x.length() != L)
  {
    throw sim_exception("casdec_x::process - ce.size <> x.size", x.length());
  }

  y.set_size(L, 2);
  // for cell 0 x_cas = x
  y.set_col(0, x_cas);
  y.set_col(1, to_cvec(to_vec(ce_cas), zeros(ce_cas.length())));
  x_cas = x;
  ce_cas = ce;

  for (int i = 0; i < output_cell_index; i++)
  {
    y = (dec_cell_vec[i]).process(ce_cas, x_cas);
    x_cas = y.get_col(0);
    ce_cas = to_bvec(to_ivec(real(y.get_col(1))));
  }

  debug(3) << "casdec_x::process y = " << y << endl;
  return (y);

}
} // namespace SIM