/*xxx
* \brief - SIM::circbuff - cirular buffer derived from itpp::Circular_Buffer<double>
* \author maki
*/



#include "sim\sim_circbuff.hpp"
#include "sim\_sim_exception.hpp"
#include "__debug_level.h"
#include "debug.hpp"

namespace SIM
{

void circbuff::set_size(int m)
{
  if(m <= 0)
  {
    throw sim_exception("circbuff::set_size - bad size", m);
  }
  itpp::Circular_Buffer<double>::set_size(m);
}

void circbuff::set_output(double yout)
{
  y0 = yout;
}

int circbuff::get_size(void)
{
  return (size());
}


double circbuff::get_output(void)
{
  return (y0);
}

vec circbuff::generate(const bvec &ce)
{
  vec y;
  int K, i;

  debug(3)  << "circbuff::generate ce = " << ce << endl;

  K = ce.length();
  y.set_length(K);
  for(i = 0; i < K; i++)
  {
    if(ce(i))
    {
      try
      {
        y0 = get();
        put(y0);
      }
      catch(...)
      {
        throw sim_exception(" circbuff::generate - error in get()/put()");
      }
    }
    y(i) = y0;
  }

  debug(3) << "circbuff::generate y = " << y << endl;
  return (y);
}

vec circbuff::process(const bmat &ceio, const vec &x)
{
  vec y;
  int K, i;

  debug(3) << "circbuff::process ceio = " << ceio << endl;
  debug(3) << "circbuff::process    x = " << x << endl;

  if(ceio.cols() != 2)
  {
    throw sim_exception("circbuff::process - ceio.cols() <> 2 ", ceio.cols());
  }
  if(x.length() != ceio.rows())
  {
    throw sim_exception("circbuff::process - x.lenght() <> ceio.rows() ", x.length());
  }
  
  K = ceio.rows();
  y.set_length(K);
  for(i = 0; i < K; i++)
  {
    // cei - input sample to cb
    if(ceio(i, 0))
    {
      put(x(i));
    }
    // ceo - get sample from cb
    if(ceio(i, 1))
    {
      try
      {
        y0 = get();
      }
      catch(...)
      {
        throw sim_exception(" circbuff::process - error in get()");
      }
    }
    y(i) = y0;
  }

  debug(3) << "circbuff::process  y = " << y << endl;
  return (y);
}

} // namespace SIM