/*xxx
* \brief - SIM::circbuff_x - complex circular buffer derived from itpp::Circular_Buffer<complex>
* \author maki
*/


#include "sim\sim_circbuff_x.hpp"
#include "sim\_sim_exception.hpp"
#include "__debug_level.h"
#include "debug.hpp"

namespace SIM
{

void circbuff_x::set_size(int m)
{
  if(m <= 0)
  {
    throw sim_exception("circbuff_x::set_size - bad size", m);
  }
  itpp::Circular_Buffer< std::complex<double> >::set_size(m);
}

void circbuff_x::set_output(complex<double> yout)
{
  y0 = yout;
}

int circbuff_x::get_size(void)
{
  return (size());
}


complex<double> circbuff_x::get_output(void)
{
  return (y0);
}

cvec circbuff_x::generate(const bvec &ce)
{
  cvec y;
  int K, i;

  debug(3)  << "circbuff_x::generate ce = " << ce << endl;

  K = ce.length();
  y.set_length(K);
  for(i = 0; i < K; i++)
  {
    if(bool(ce(i)))
    {
      try
      {
        y0 = get();
        put(y0);
      }
      catch(...)
      {
        throw sim_exception(" circbuff_x::generate - error for get()/put()");
      }
    }
    y(i) = y0;
  }

  debug(3) << "circbuff_x::generate y = " << y << endl;
  return (y);
}

cvec circbuff_x::process(const bmat &ceio, const cvec &x)
{
  cvec y;
  int K, i;

  debug(3) << "circbuff_x::process ceio = " << ceio << endl;
  debug(3) << "circbuff_x::process    x = " << x << endl;

  if(ceio.cols() != 2)
  {
    throw sim_exception("circbuff_x::process - ceio.cols() <> 2 ", ceio.cols());
  }
  if(x.length() != ceio.rows())
  {
    throw sim_exception("circbuff_x::process - x.lenght() <> ceio.rows() ", x.length());
  }

  K = ceio.rows();
  y.set_length(K);
  for(i = 0; i < K; i++)
  {
    // cei - input sample to cb
    if(bool(ceio(i, 0)))
    {
      put(x(i));
    }
    // ceo - get sample from cb
    if(bool(ceio(i, 1)))
    {
      try
      {
        y0 = get();
      }
      catch(...)
      {
        throw sim_exception(" circbuff_x::process - error for get()");
      }
    }
    y(i) = y0;
  }

  debug(3) << "circbuff_x::process  y = " << y << endl;
  return (y);
}

} // namespace SIM