/*xxx
* \brief - SIM::cofdm_dem - COFDM demodulator - derived from itpp::OFDM
* \author maki
*/

#include "sim\sim_cofdm_dem.hpp"
#include "sim\_sim_exception.hpp"
#include "debug.hpp"
#include "__debug_level.h"


namespace SIM
{

void cofdm_dem::set_NFFT(int n)
{
  try
  {
    NFFT = n;
    OFDM::set_parameters(NFFT, CP, 1);
    // itpp ++ modulator scale is NFFT/sqrt(NFFT+CP)
    // norm_factor = sqrt((NFFT^2) / (NFFT + CP));
    // outtemp = ifft()* norm_factor;
    scale = std::sqrt(static_cast<double>(NFFT)) / std::sqrt(static_cast<double>(NFFT + CP));

  }
  catch(...)
  {
    throw sim_exception("cofdm_dem::set_N - bad size", n);
  }
}

void cofdm_dem::set_CP(int cp)
{
  try
  {
    CP = cp;
    OFDM::set_parameters(NFFT, CP, 1);
    scale = std::sqrt(static_cast<double>(NFFT)) / std::sqrt(static_cast<double>(NFFT + CP));
  }
  catch(...)
  {
    throw sim_exception("cofdm_dem::set_CP - bad size", cp);
  }
}

void cofdm_dem::set_scale(double s)
{
  scale = s;
}

void cofdm_dem::set_symbol(cvec x)
{
  if(x.length() == (NFFT + CP))
  {
    symbol = x;
  }
  else
  {
    throw sim_exception("cofdm_dem::set_symbol -x.lenght<>(NFFT+CP)=", NFFT + CP);
  }
}

int cofdm_dem::get_NFFT()
{
  return (NFFT);
}

int cofdm_dem::get_CP()
{
  return (CP);
}

double cofdm_dem::get_scale()
{
  return (scale);
}

cvec cofdm_dem::get_symbol()
{
  return symbol;
}
cvec cofdm_dem::get_carriers()
{
  try
  {
    y0 = scale * OFDM::demodulate(symbol);
  }
  catch (...)
  {
    throw sim_exception("cofdm_dem::get_carriers - demodulation error");
  }
  return (y0);
}

cmat cofdm_dem::process(const bvec &ce, const cmat &x)
{
  cmat y;
  int N;

  debug(3) << "cofdm_dem::process ce = " << ce << endl;
  debug(3) << "cofdm_dem::process  x = " << x << endl;

  N = ce.length();
  y.set_size(N, NFFT);

  if (x.rows() != N)
  {
    throw sim_exception("cofdm_dem::process - ce.size <> x.rows", x.rows());
  }
  if (x.cols() != NFFT+CP)
  {
    throw sim_exception("cofdm_dem::process - x.cols <> NFFT+CP ", x.cols());
  }

  for (int i = 0; i < N; i++)
  {
    if (ce[i])
    {
      symbol = x.get_row(i);
      cofdm_dem::get_carriers();
    }
    y.set_row(i, y0);
  }

  debug(3) << "cofdm_dem::process  y = " << y << endl;

  return (y);
}

} // namespace SIM