/*xxx
* \brief - SIM::cofdm_demap - demap [I,Q] QAM data carriers into QAM codes and BPSK pilot carriers into booleans
* \author maki
*/

#include "sim\sim_cofdm_demap.hpp"
#include "sim\_sim_exception.hpp"
#include "__debug_level.h"
#include "debug.hpp"

namespace SIM
{

void cofdm_demap::set_NFFT(int n)
{
  try
  {
    NFFT = n;
    y0.set_size(NFFT);
  }
  catch(...)
  {
    throw sim_exception("cofdm_demap::set_NFFT - bad size", n);
  }
}

void cofdm_demap::set_PA(double pa)
{
  PA = pa;
}

void cofdm_demap::set_qam_size(int m)
{
  qamdem.set_size(m);
}

void cofdm_demap::set_data_carriers(ivec dcindx)
{
  if(dcindx.length() < NFFT)
  {
    if(itpp::min(dcindx) >= 0)
    {
      if(itpp::max(dcindx) < NFFT)
      {
        data_carriers = dcindx;
      }
      else
      {
        throw sim_exception("cofdm_demap::set_data_carriers - max(dcindx) > NFFT=", NFFT);
      }
    }
    else
    {
      throw sim_exception("cofdm_demap::set_data_carriers - min(dcindx) <  0 ");
    }

  }
  else
  {
    throw sim_exception("cofdm_demap::set_data_carriers - bad dcindx.size() > NFFT=", NFFT);
  }
}

void cofdm_demap::set_pilots_carriers(ivec pcindx)
{
  if(pcindx.length() < NFFT)
  {
    if(itpp::min(pcindx) >= 0)
    {
      if(itpp::max(pcindx) < NFFT)
      {
        pilots_carriers = pcindx;
      }
      else
      {
        throw sim_exception("cofdm_demap::set_pilots_carriers - max(pcindx) > NFFT=", NFFT);
      }
    }
    else
    {
      throw sim_exception("cofdm_demap::set_pilots_carriers - min(dcindx) <  0 ");
    }
  }
  else
  {
    throw sim_exception("cofdm_demap::set_pilots_carriers - bad pcindx.size() > NFFT=", NFFT);
  }
}

void cofdm_demap::set_zero_carriers(ivec zcindx)
{
  if(zcindx.length() < NFFT)
  {
    if(itpp::min(zcindx) >= 0)
    {
      if(itpp::max(zcindx) < NFFT)
      {
        zero_carriers = zcindx;
      }
      else
      {
        throw sim_exception("cofdm_demap::set_zero_carriers - max(zcindx) > NFFT=", NFFT);
      }
    }
    else
    {
      throw sim_exception("cofdm_demap::set_zero_carriers - min(zcindx) <  0 ");
    }
  }
  else
  {
    throw sim_exception("cofdm_demap::set_zero_carriers - bad zcindx.size() > NFFT=", NFFT);
  }

}

void cofdm_demap::set_carriers(cvec c)
{
  if(c.length() == NFFT)
  {
    carriers = c;
  }
  else
  {
    throw sim_exception("cofdm_demap::set_carriers - bad size  <> NFFT c.size() = ", c.size());
  }
}


ivec cofdm_demap::get_data()
{
  ivec iv;
  bvec ce1;
  cvec x1;
  int K = data_carriers.length();
  int i;

  ce1.set_length(1);
  ce1.ones();
  x1.set_length(1);
  iv.set_length(K);
  for(i = 0; i < K; i++)
  {
    // turn x1 vector into vector of size[1]
    x1(0) = carriers(data_carriers(i));
    iv(i) = (qamdem.process(ce1, x1))(0);
  }
  return (iv);
}

bvec cofdm_demap::get_pilots()
{
  bvec bv;
  complexd x1;
  int K = pilots_carriers.length();
  int i;

  bv.set_length(K);
  for(i = 0; i < K; i++)
  {
    // turn x1 vector into vector of size[1]
    x1 = carriers(pilots_carriers(i));
    bv(i) = (real(x1) >= 0) ? 1 : 0;
  }
  return (bv);
}

imat cofdm_demap::process(const bvec &ce, const cmat &x)
{
  imat y;
  ivec d;
  ivec p;
  int N;
  int K = data_carriers.length();
  int L = pilots_carriers.length();

  debug(3) << "cofdm_demap::process ce = " << ce << endl;
  debug(3) << "cofdm_demap::process  x = " << x << endl;

  N = ce.length();
  y.set_size(N, pilots_carriers.length() + data_carriers.length());

  if (x.rows() != N)
  {
    throw sim_exception("cofdm_demap::process - ce.size <> x.rows", x.rows());
  }
  if (x.cols() != NFFT)
  {
    throw sim_exception("cofdm_demap::process - x.cols <> NFFT ", x.cols());
  }

  for (int i = 0; i < N; i++)
  {
    if (ce[i])
    {
      carriers = x.get_row(i);
      if (K)
      {
        d = cofdm_demap::get_data();
      }
      if (L)
      {
        p = to_ivec(cofdm_demap::get_pilots());
      }
      y0 = concat(p, d); // [PILOTS_CODES|QAM_CODES]
    }
    y.set_row(i, y0);
  }

  debug(3) << "cofdm_demap::process  y = " << y << endl;

  return (y);
}



} // namespace SIM