/*xxx
* \brief - SIM::cofdm_mod - COFDM modulator derived from itpp::OFDM
* \author maki
*/

#include "sim\sim_cofdm_mod.hpp"
#include "sim\_sim_exception.hpp"
#include "debug.hpp"
#include "__debug_level.h"

namespace SIM
{

void cofdm_mod::set_NFFT(int n)
{
  try
  {
    NFFT = n;
    OFDM::set_parameters(NFFT, CP, 1);
    // itpp modulator scale is NFFT/sqrt(NFFT+CP)
    // norm_factor = sqrt(( Nfft * Nfft) / (Nfft + Ncp));
    // outtemp = ifft()* norm_factor;
    // make it normal i.e. RMS is not function of CP
    scale = std::sqrt(static_cast<double>(NFFT + CP)) / std::sqrt(static_cast<double>(NFFT));
  }
  catch(...)
  {
    throw sim_exception("cofdm_mod::set_NFFT - bad size", n);
  }
}

void cofdm_mod::set_CP(int cp)
{
  try
  {
    CP = cp;
    OFDM::set_parameters(NFFT, CP, 1);
    // itpp modulator scale is NFFT/sqrt(NFFT+CP)
    // make it normal i.e. RMS is not function of CP
    scale = std::sqrt(static_cast<double>(NFFT + CP)) / std::sqrt(static_cast<double>(NFFT));
  }
  catch(...)
  {
    throw sim_exception("cofdm_mod::set_CP - bad size", cp);
  }
}

void cofdm_mod::set_scale(double s)
{
  scale = s;
}

void cofdm_mod::set_carriers(cvec x)
{
  if(x.length() == NFFT)
  {
    carriers = x;
  }
  else
  {
    throw sim_exception("cofdm_mod::set_carriers - x.lenght()<> NFFT =", NFFT);
  }
}

int cofdm_mod::get_NFFT()
{
  return (NFFT);
}

int cofdm_mod::get_CP()
{
  return (CP);
}

double cofdm_mod::get_scale()
{
  return (scale);
}

cvec cofdm_mod::get_carriers()
{
  return carriers;
}

cvec cofdm_mod::get_symbol()
{
  try
  {
    y0 = scale * OFDM::modulate(carriers);
  }
  catch (...)
  {
    throw sim_exception("cofdm_mod::get_symbol - modulataion error");
  }
  return (y0);
}

cmat cofdm_mod::process(const bvec &ce, const cmat &x)
{
  cmat y;
  int N;

  debug(3) << "cofdm_mod::process ce = " << ce << endl;
  debug(3) << "cofdm_mod::process  x = " << x << endl;

  N = ce.length();
  y.set_size(N, NFFT+CP);

  if (x.rows() != N)
  {
    throw sim_exception("cofdm_mod::process - ce.size <> x.rows", x.rows());
  }
  if (x.cols() != NFFT)
  {
    throw sim_exception("cofdm_mod::process - x.cols <> NFFT ", x.cols());
  }

  for (int i = 0; i < N; i++)
  {
    if (ce[i])
    {
      carriers = x.get_row(i);
      cofdm_mod::get_symbol();
    }
    y.set_row(i, y0);
  }

  debug(3) << "cofdm_mod::process  y = " << y << endl;

  return (y);
}

} // namespace SIM