/*xxx
* \brief - SIM::cofdm_sel - carriers selector
* \author maki
*/

#include "sim\sim_cofdm_sel.hpp"
#include "sim\_sim_exception.hpp"
#include "__debug_level.h"
#include "debug.hpp"

namespace SIM
{

void cofdm_sel::set_NFFT(int n)
{
  try
  {
    NFFT = n;
    y0.set_size(NFFT);
  }
  catch(...)
  {
    throw sim_exception("cofdm_sel::set_NFFT - bad size", n);
  }
}

void cofdm_sel::set_carriers_selector(ivec c_indx)
{
  if(c_indx.length() <= NFFT)
  {
    if(itpp::min(c_indx) >= 0)
    {
      if(itpp::max(c_indx) < NFFT)
      {
        sel_carriers = c_indx;
      }
      else
      {
        throw sim_exception("cofdm_sel::set_sel_carriers - max(c_indx) > NFFT=", itpp::max(c_indx));
      }
    }
    else
    {
      throw sim_exception("cofdm_sel::set_sel_carriers - min(cindx) <  0 ", itpp::min(c_indx));
    }
  }
  else
  {
    throw sim_exception("cofdm_sel::set_sel_carriers - bad cindx.size() > NFFT=", c_indx.length());
  }
}


void cofdm_sel::set_carriers(cvec c)
{
  if(c.length() == NFFT)
  {
    carriers = c;
  }
  else
  {
    throw sim_exception("cofdm_sel::set_symbol - bad c.size() <> NFFT=", c.length());
  }
}


cvec cofdm_sel::get_selected_carriers()
{
  cvec cv;
  int K = sel_carriers.length();
  int i;

  cv.set_length(K);
  for(i = 0; i < K; i++)
  {
    cv(i) = carriers(sel_carriers(i));
  }
  y0 = cv;
  return (cv);
}

cmat cofdm_sel::process(const bvec &ce, const cmat &x)
{
  cmat y;
  int N;
  int K = sel_carriers.length();

  debug(3) << "cofdm_sel::process ce = " << ce << endl;
  debug(3) << "cofdm_sel::process  x = " << x << endl;

  N = ce.length();

  if (x.rows() != N)
  {
    throw sim_exception("cofdm_sel::process - ce.size <> x.rows", x.rows());
  }

  if (x.cols() != NFFT)
  {
    throw sim_exception("cofdm_sel::process - x.cols <> NFFT ", x.cols());
  }

  y.set_size(N, K);

  for (int i = 0; i < N; i++)
  {
    if (ce[i])
    {
      carriers = x.get_row(i);
      get_selected_carriers();
    }
    y.set_row(i, y0);
  }

  debug(3) << "cofdm_sel::process  y = " << y << endl;

  return (y);
}

} // namespace SIM