/*xxx
* \brief - SIM::counter - modulo N up counter with clock enable signal - ce
* \author maki
*/

#include "sim\sim_counter.hpp"
#include "sim\_sim_exception.hpp"
#include "__debug_level.h"
#include "debug.hpp"

namespace SIM
{

void counter::set_N(int N)
{
  if(N > 0)
  {
    Nmod = N;
  }
  else
  {
    throw sim_exception("counter.set_N  N<= 0", N);
  }
};

void counter::set_state(int c)
{
  if(c < Nmod)
  {
    cnt = c;
  }
  else
  {
    throw sim_exception("counter.set_state c > Nmod", c);
  }
};

bvec counter::generate(const bvec &ce)
{
  bvec y;
  int L;

  debug(3) << "counter::gen \n ce=" << ce << endl;
  L = ce.length();
  y.set_size(L);
  y = zeros_b(L);
  for(int i = 0; i < L; i++)
  {
    if(ce[i])
    {
      cnt++;
      if(cnt >= Nmod)
      {
        cnt = 0;
        y[i] = 1;
      }
    }
  }
  debug(3) << "counter::gen \n y=" << y << endl;
  return (y);
}

} // namespace SIM