/*xxx
* \brief - SIM::ejp - complex sine for normalized phase
* \author maki
*/

#include "sim\sim_ejp.hpp"
#include "sim\_sim_exception.hpp"
#include "__debug_level.h"
#include "debug.hpp"

namespace SIM
{

void ejp::set_output(complexd yout)
{
  y0 = yout;
}


complexd ejp::get_output(void)
{
  return (y0);
}

cvec ejp::process(const bvec &ce, const vec &x)
{
  cvec y;
  int N;

  debug(3) << "ejp::process ce = " << ce << endl;
  debug(3) << "ejp::process  x = " << x << endl;

  N = ce.length();
  if(x.length() != N)
  {
    throw sim_exception("ejp::process - ce.size <> x.size()", x.length());
  }
  
  y.set_length(N);
  
  for(int i = 0; i < N; i++)
  {
    if(ce[i])
    {
      y0 = std::polar(1.0, 2.0 * pi * x[i]);
    }
    y[i] = y0;
  }
  debug(3) << "ejp::process y = " << y << endl;
  return (y);
}

} // namespace SIM