/*xxx
* \brief - SIM::fir - derived from SPUC::fir
* \author maki
*/

#include "sim\sim_fir.hpp"
#include "sim\_sim_exception.hpp"
#include "__debug_level.h"
#include "debug.hpp"



namespace SIM
{

void fir::set_state(const vec &v)
{
  int k, N;

  N = get_size();
  if(v.length() != N)
  {
    throw sim_exception("fir::set_state v.lenght <> fir.size()", v.length());
  }

  for(k = 0; k < N; k++)
  {
    z[k] = v[k];
  }
}

void fir::set_output(double yout)
{
  y0 = yout;
}

vec fir::get_state(void)
{
  return(get_input());
}

double fir::get_output(void)
{
  return(y0);
}

vec fir::process(const bvec &ce, const vec &x)
{
  vec y;
  int N;

  debug(3) << "fir::proc \n ce=" << ce << "\n  x=" << x << endl;
  N = ce.length();
  if(x.length() != N)
  {
    throw sim_exception("fir::process - ce.size <> x.size", x.length());
  }
  y.set_size(N);
  for(int i = 0; i < N; i++)
  {
    if(ce[i])
    {
      y0 = update(x[i]);
    }
    y[i] = y0;
  }
  debug(3) << "fir::proc \n y=" << y << endl;
  return (y);
}

} // namespace SIM