/*xxx
* \brief SIM::fir_up - FIR up-sampling filter
* \author maki
*/

#include "sim\sim_fir_up.hpp"
#include "sim\_sim_exception.hpp"
#include "__debug_level.h"
#include "debug.hpp"

namespace SIM
{

vec fir_up::process(const bmat &ceio, const vec &x)
{
  vec y;
  int N;
  bvec cei, ceo;
  bvec btick = "1";      // vector of size 1
  vec sample = "0.0";   // vector of size 1

  debug(3) << "fir_up::proc ceio =\n" << ceio << endl;
  debug(3) << "fir_up::proc    x =\n" << x << endl;

  if(ceio.cols() != 2)
  {
    throw sim_exception("fir_up::process - ceio.cols <> 2");
  }

  cei = ceio.get_col(0);
  ceo = ceio.get_col(1);

  if(cei.length() != x.length())
  {
    throw sim_exception("fir_up::process - cei.size <> x.size");
  }

  N = x.length();
  y.set_size(N);

  for(int i = 0; i < N; i++)
  {
    if(bool(cei[i]) && bool(ceo[i]))
    {
      sample[0] = x[i];
      y0 = (fir::process(btick, sample))[0];
    }
    else if(bool(ceo[i]))
    {
      sample[0] = 0.0;
      y0 = (fir::process(btick, sample))[0];
    }
    y[i] = y0;
  }

  debug(3) << "fir_up::proc \n y=" << y << endl;
  return (y);
}

} // namespace SIM