/*xxx
* \brief SIM::fir_x_up complex up-sampling filter
* \author maki
*/

#include "sim\sim_fir_up_x.hpp"
#include "sim\_sim_exception.hpp"
#include "__debug_level.h"
#include "debug.hpp"


namespace SIM
{

cvec fir_up_x::process(const bmat &ceio, const cvec &x)
{
  cvec y;
  int N;
  bvec cei, ceo;
  bvec btick = "1"; // vector of size 1
  cvec sample = "0.0+0.0i";

  debug(3) << "fir_up_x::proc ceio= \n" << ceio << endl;
  debug(3) << "fir_up_x::proc \n x = \n" << x << endl;

  if(ceio.cols() != 2)
  {
    throw sim_exception("fir_up_x::process - ceio.cols <> 2");
  }

  cei = ceio.get_col(0);
  ceo = ceio.get_col(1);

  if(cei.length() != x.length())
  {
    throw sim_exception("fir_up_x::process - cei.size <> x.size");
  }

  N = x.length();
  y.set_size(N);

  for(int i = 0; i < N; i++)
  {
    if(bool(cei[i]) && bool(ceo[i]))
    {
      sample[0] = x[i];
      y0 = (fir_x::process(btick, sample))[0];
    }
    else if(bool(ceo[i]))
    {
      sample[0] = std::complex<double>(0.0, 0.0);
      y0 = (fir_x::process(btick, sample))[0];
    }
    y[i] = y0;
  }

  debug(3) << "fir_up_x::proc \n y=" << y << endl;
  return (y);
}

} // namespace SIM