/*xxx
* \brief - fir_x - derived from SPUC::fir<complex<double>>
* \author maki
*/

#include "sim\sim_fir_x.hpp"
#include "sim\_sim_exception.hpp"
#include "__debug_level.h"
#include "debug.hpp"

namespace SIM
{

void fir_x::set_state(const cvec &cv)
{
  int k, N;

  N = get_size();
  if(cv.length() != N)
  {
    throw sim_exception("fir_x::set_state v.lenght <> fir_x.size()", cv.length());
  }
  for(k = 0; k < N; k++)
  {
    z[k] = cv[k];
  }
}

void fir_x::set_output(complexd yout)
{
  y0 = yout;
}

cvec fir_x::get_state(void)
{
  return(get_input());
}

complexd fir_x::get_output(void)
{
  return(y0);
}

cvec fir_x::process(const bvec &ce, const cvec &x)
{
  cvec y;
  int N;

  debug(3) << "fir_x::proc \n ce=" << ce << "\n x=" << x << endl;
  N = ce.length();
  if(x.length() != N)
  {
    throw sim_exception("fir_x::process - ce.size <> x.size", x.length());
  }
  y.set_size(N);
  for(int i = 0; i < N; i++)
  {
    if(ce[i])
    {
      y0 = update(x[i]);
    }
    y[i] = y0;
  }
  debug(3) << "fir_x::proc \n y=" << y << endl;
  return (y);
}
} // namespace SIM