/*xxx
* \brief - SIM::bin2int - SIM layer implementation of binary to integer converter
* \author maki
*/


#include "sim\sim_int2bin.hpp"
#include "sim\_sim_exception.hpp"
#include "__debug_level.h"
#include "debug.hpp"

namespace SIM
{

void int2bin::set_symbol_size(int W)
{
  if(W > 0)
  {
    symbol_size = W;
  }
  else
  {
    throw sim_exception("int2bin.set_symbol_size - not in range [ >0 ]", W);
  }
}

int int2bin::get_symbol_size()
{
  return (symbol_size);
}


void int2bin::set_output(const bvec &yout)
{
  y0 = yout;
}

bvec int2bin::get_output()
{
  return (y0);
}

void int2bin::set_msb_flag(bool msb)
{
  msb_first = msb;
}

bool int2bin::get_msb_flag()
{
  return (msb_first);
}


bmat int2bin::process(const bvec &ce, const ivec &x)
{
  bmat y;
  int N;

  debug(3) << "int2bin::process ce = " << ce << endl;
  debug(3) << "int2bin::process x = " << x << endl;
  N = ce.length();
  if(x.length() != N)
  {
    throw sim_exception("int2bin::process - ce.size <> x.rows()", x.length());
  }
  y.set_size(N, symbol_size);
  for(int i = 0; i < N; i++)
  {
    if(bool(ce[i]))
    {
      y0 = dec2bin(symbol_size, x[i]);
      if(!msb_first)
      {
        y0 = reverse(y0);
      }
    }
    y.set_row(i, y0);
  }
  debug(3) << "int2bin::process y = " << y << endl;
  return (y);
}

} // namespace SIM