/*xxx
* \brief - SIM::iq2ap -  IQ to amplitude/phase
* \author maki
*/


#include "sim\sim_iq2ap.hpp"
#include "sim\_sim_exception.hpp"
#include "__debug_level.h"
#include "debug.hpp"


namespace SIM
{

void iq2ap::set_output(vec yout)
{
  y0 = yout;
}


vec iq2ap::get_output(void)
{
  return (y0);
}

mat iq2ap::process(const bvec &ce, const cvec &x)
{
  mat y;
  int N;

  debug(3) << "iq2ap::process ce = " << ce << endl;
  debug(3) << "iq2ap::process  x = " << x << endl;

  N = ce.length();
  if(x.length() != N)
  {
    throw sim_exception("iq2ap::process - ce.size <> x.size()", x.length());
  }
  
  y.set_size(N, 2);
  for(int i = 0; i < N; i++)
  {
    if(ce[i])
    {
      y0(0) = std::abs(x[i]);
      y0(1) = std::arg(x[i]);
    }
    y.set_row(i, y0);
  }
  debug(3) << "iq2ap::process  y = " << y << endl;
  return (y);
}

} // namespace SIM