/*xxx
* \brief - lsfr - derived from itpp::LFSR with ce - clock enable signal
* \author maki
*/

#include "sim\sim_lfsr.hpp"
#include "sim\_sim_exception.hpp"
#include "__debug_level.h"
#include "debug.hpp"

namespace SIM
{

void lfsr::set_poly(const bvec &bpoly)
{
  int N;

  poly_gen = bpoly;
  set_connections(poly_gen);
  N = bpoly.length() - 1;
  s0 = reverse(dec2bin(N, 1)); // 0 is forbiden state for LFSR - set default reset to 1, convert to LSB == rightmost bit
  set_state(s0);			   // perform reset
}

void lfsr::set_prbs(int M)
{
  bvec bpoly;

  switch(M)
  {
    case 3:
      //            0 1 2 3
      bpoly = bvec("1 0 1 1 ");
      break;

    case 4:
      //            0 1 2 3 4
      bpoly = bvec("1 0 0 1 1");
      break;

    case 5:
      //            0 1 2 3 4 5
      bpoly = bvec("1 0 0 1 0 1");
      break;

    case 6:
      //            0 1 2 3 4 5 6
      bpoly = bvec("1 0 0 0 0 1 1");
      break;

    case 7:
      //            0 1 2 3 4 5 6 7
      bpoly = bvec("1 0 0 0 0 0 1 1");
      break;

    case 8:
      //          0 1 2 3 4 5 6 7 8
      bpoly = bvec("1 0 0 0 1 1 1 0 1");
      break;

    case 9:
      //            0 1 2 3 4 5 6 7 8 9
      bpoly = bvec("1 0 0 0 0 1 0 0 0 1");
      break;

    case 15:
      //            0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5
      bpoly = bvec("1 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1");
      break;

    case 23:
      //            0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1 2 3
      bpoly = bvec("1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 1");
      break;

    case 31:
      //            0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1
      bpoly = bvec("1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 1");
      break;

    default:
      throw sim_exception("lfsr::set_prbs - unknown param");
  }
  set_poly(bpoly);
}

void lfsr::set_symbol_size(int W)
{
  if(W > 0)
  {
    symbol_size = W;
    y0.set_size(W);
    y0.zeros();
  }
  else
  {
    throw sim_exception("lfsr.set_symbol_size - not in range [1..inf]", W);
  }
}

void lfsr::set_reset_state(const bvec &binit)
{
  if(binit.length() == get_length())
  {
    s0 = binit;
  }
  else
  {
    throw sim_exception("lfsr.set_reset_state - bad size", binit.length());
  }
}

void lfsr::set_rev_flag(bool flag)
{
  rev_flag = flag;
}

bvec lfsr::get_reset_state()
{
  return (s0);
}

void lfsr::set_output(const bvec &yout)
{
  y0 = yout;
}


bvec lfsr::get_poly()
{
  return (poly_gen);
}

int lfsr::get_symbol_size()
{
  return (symbol_size);
}

bvec lfsr::get_output()
{
  return (y0);
}

bool lfsr::get_rev_flag()
{
  return rev_flag;
}

bvec lfsr::get_state()
{

  if(rev_flag)
  {
    return (reverse(itpp::LFSR::get_state()));
  }
  else
  {
    return (itpp::LFSR::get_state());
  }
}


bmat lfsr::generate(const bvec &ce)
{
  bmat y;
  int N;

  debug(3) << "lfsr::gen \n ce=" << ce << endl;
  N = ce.length();
  y.set_size(N, symbol_size);
  for(int i = 0; i < N; i++)
  {
    if(bool(ce[i]))
    {
      y0 = shift(symbol_size);
    }
    if(rev_flag)
    {
      y.set_row(i, reverse(y0));  // reverse needed when using symbols in BERT synchronization - LFSR state must be continous in time
    }
    else
    {
      y.set_row(i, y0);
    }
  }
  debug(3) << "lfsr::gen \n y=" << y << endl;
  return (y);
}


} // namespace SIM