/*xxx
* \brief - SIM::lsr - SIM layer implementation of linear shift register
* \author maki
*/


#include "sim\sim_lsr.hpp"
#include "sim\_sim_exception.hpp"
#include "__debug_level.h"
#include "debug.hpp"

namespace SIM
{

bvec lsr::shift(const bvec &bvin)
{
  if(bvin.length() == symbol_size)
  {
    bvec temp = memory.right(symbol_size);
    memory.shift_right(bvin);
    return temp;
  }
  else
  {
    throw sim_exception("lsr.shift - bvin.size <> symbol_size", bvin.length());
  }
}


void lsr::set_length(int L)
{
  memory.set_size(L);
  s0.set_size(L);
  s0.zeros();
  set_state(s0);
}

void lsr::set_symbol_size(int W)
{
  if((W > 0) && (W <= get_length()))
  {
    symbol_size = W;
    y0.set_size(W);
    y0.zeros();
  }
  else
  {
    throw sim_exception("lsr.set_symbol_size - not in range [1.. memory.size()]", W);
  }
}

void lsr::set_state(const bvec &state)
{
  if(memory.length() == state.length())
  {
    memory = state;
  }
  else
  {
    throw sim_exception("lsr.set_state  state.size() != memory.size() ", state.length());
  }
}

void lsr::set_reset_state(const bvec &binit)
{
  if(binit.length() == get_length())
  {
    s0 = binit;
  }
  else
  {
    throw sim_exception("lsr.set_reset_state - bad size", binit.length());
  }
}

void lsr::set_output(const bvec &yout)
{
  if(yout.length() == get_symbol_size())
  {
    y0 = yout;
  }
  else
  {
    throw sim_exception("lsr.set_output - bad size", yout.length());
  }
}


int lsr::get_length(void)
{
  return memory.size();
}

bvec lsr::get_state(void)
{
  return memory;
}

int lsr::get_symbol_size()
{
  return (symbol_size);
}


bvec lsr::get_reset_state()
{
  return (s0);
}

bvec lsr::get_output()
{
  return (y0);
}

bmat lsr::process(const bvec &ce, const bmat &x)
{
  bmat y;
  int N;


  debug(3) << "lsr::process \n ce=" << ce << "\n x=" << x << endl;
  N = ce.length();
  if(x.rows() != N)
  {
    throw sim_exception("lsr::process - ce.size <> x.rows()", x.rows());
  }
  if(x.cols() != symbol_size)
  {
    throw sim_exception("lsr::process - x.cols <> symbol_size", x.cols());
  }

  y.set_size(N, symbol_size);
  for(int i = 0; i < N; i++)
  {
    if(bool(ce[i]))
    {
      y0 = shift(x.get_row(i));
    }
    y.set_row(i, y0);
  }
  debug(3) << " lsr::process \n y=" << y << endl;
  return (y);
}

} // namespace SIM