/*xxx
* \brief - SIM::mix - multipling mixer
* \author maki
*/


#include "sim\sim_mix.hpp"
#include "sim\_sim_exception.hpp"
#include "__debug_level.h"
#include "debug.hpp"


namespace SIM
{

void mix::set_output(double yout)
{
  y0 = yout;
}

double mix::get_output(void)
{
  return (y0);
}

vec mix::process(const bvec &ce, const mat &x)
{
  vec y;
  int N;

  debug(3) << "mix::process ce = " << ce << endl;
  debug(3) << "mix::process  x = " << x << endl;

  N = ce.length();
  if(x.rows() != N)
  {
    throw sim_exception("mix::process - ce.size <> x.rows()", x.rows());
  }
  if(x.cols() != 2)
  {
    throw sim_exception("mix::process - x=[x1,x1] - x.cols()!=2", x.cols());
  }

  y.set_length(N);

  for(int i = 0; i < N; i++)
  {
    if(ce[i])
    {
        y0 = x(i, 0) * x(i, 1);
    }
    y[i] = y0;
  }
  debug(3) << "mix::process  y = " << y << endl;
  return (y);
}

} // namespace SIM