/*xxx
* \brief - SIM::mix_x - multipling two input complex mixer
* \author maki
*/

#include "sim\sim_mix_x.hpp"
#include "sim\_sim_exception.hpp"
#include "__debug_level.h"
#include "debug.hpp"

namespace SIM
{

void mix_x::set_output(complexd yout)
{
  y0 = yout;
}

complexd mix_x::get_output(void)
{
  return (y0);
}

cvec mix_x::process(const bvec &ce, const cmat &x)
{
  cvec y;
  int N;

  debug(3) << "mix_x::process ce = " << ce << endl;
  debug(3) << "mix_x::process  x = " << x << endl;

  N = ce.length();
  if(x.rows() != N)
  {
    throw sim_exception("mix_x::process - ce.size <> x.rows()", x.rows());
  }
  if(x.cols() != 2)
  {
    throw sim_exception("mix_x::process - x=[x1,x1] - x.cols()!=2", x.cols());
  }

  y.set_length(N);

  for(int i = 0; i < N; i++)
  {
    if(ce[i])
    {
      y0 = x(i, 0) * x(i, 1);
    }
    y[i] = y0;
  }

  debug(3) << "mix_x::process  y = " << y << endl;
  return (y);
}

} // namespace SIM