/*xxx
* \brief nco - NCO with fixed point Q1.N accumulator with output phase converted to double fractional ph=(-1.0..1.0)
* \author maki
*/


#include "sim\sim_nco.hpp"
#include "sim\_sim_exception.hpp"
#include "__debug_level.h"
#include "debug.hpp"


namespace SIM
{

void nco::set_N(int n)
{
  if(n <= 0 || n > 62)  // need at least one guard bit
  {
    throw sim_exception("nco::set_N - invalid N ", int(n));
  }
  Nq_bits = n;
#pragma warning( suppress : 4244 )
  q_scale = pow2(Nq_bits); // 2^N to convert double to Q1.N
}

void nco::set_acc(double a)
{
  // saturation
  if(a >= 1.0)
  {
    acc = q_scale - 1; // you can't represent +1.0
  }
  else if(a <= -1.0)
  {
    acc = -q_scale;  // you can represent -1.0
  }
  else
  {
#pragma warning( suppress : 4244 )
    acc = (q63_t)(a * q_scale);
  }
}

void nco::set_output(const vec &yout)
{
  if(yout.length() ==  2)
  {
    y0 = yout;
  }
  else
  {
    throw sim_exception("nco::set_output - invalid size ", yout.length());
  }

}

int nco::get_N(void)
{
  return (Nq_bits);
}

double nco::get_acc(void)
{
  return (((double)acc) / q_scale);
}

vec nco::get_output(void)
{
  return (y0);
}

mat nco::process(const bvec &ce, const vec &x)
{
  int N;
  q63_t fcw;
  double cy;
  mat y;

  debug(3) << " nco::process() ce = " << ce << endl;
  debug(3) << " nco::process()  x = " << x << endl;

  N = ce.length();
  if(x.length() != N)
  {
    throw sim_exception("nco::process - ce.size <> x.size()", x.length());
  }
  y.set_size(N, 2);

  for(int i = 0; i < N; i++)
  {
    if(bool(ce[i]))
    {

      // input saturation
      if(x[i] >= 1.0)
      {
        fcw = q_scale - 1; // you can't represent 1.0
      }
      else if(x[i] <= -1.0)
      {
        fcw = -q_scale + 1; // you can represent -1.0, but this is symmetric limiter
      }
      else
      {
#pragma warning( suppress : 4244 )
        fcw = (q63_t)(x[i] * q_scale); // convert float to fixed point fractional
      }
      // phase accumulation
      acc = acc + fcw;
      // phase wrapping -1.0 < ph < 1.0 with cy for +1, -1 overflows - you need at least guard bit for this
      if(acc >= q_scale)
      {
        acc -= q_scale;
        cy = 1;
      }
      else if(acc <= -q_scale)
      {
        acc += q_scale;
        cy = -1;
      }
      else
      {
        cy = 0;
      }
      y0(0) = cy;
      y0(1) = ((double)acc) / q_scale;    // output is in double fractional
    }
    y.set_row(i, y0);
  }

  debug(3) << "nco::process() y=" << y << endl;
  return (y);
}

} // namespace SIM