/*xxx
* \brief - SIM::pam_mod - PAM demodulator - derived from itpp::pam
* \author maki
*/

#include "sim\sim_pam_dem.hpp"
#include "sim\_sim_exception.hpp"
#include "__debug_level.h"
#include "debug.hpp"

namespace SIM
{

void pam_dem::set_size(int m)
{
  double max_val, norm_max_val;

  try
  {
    M = m;
    set_M(M);
  }
  catch(...)
  {
    throw sim_exception("pam_dem.set_size - bad size", m);
  }
  max_val = ((double)M - 1.0) / sqrt(((double)M * M - 1.0) / 3);
  // [-1,1] constellation
  norm_max_val = 1.0 - 1.0 / (double)M;
  // - to get +0.5 for 1, and so on
  scale = -norm_max_val / max_val;

}

void pam_dem::set_scale(double s)
{
  scale = s;
}

void pam_dem::set_output(int yout)
{
  y0 = yout;
}

int pam_dem::get_size()
{
  return (M);
}

double pam_dem::get_scale()
{
  return (scale);
}

int pam_dem::get_output()
{
  return (y0);
}

ivec pam_dem::process(const bvec &ce, const vec &x)
{
  ivec y;
  int N;
  ivec iv;
  vec v;

  debug(3) << "pam_dem::process ce = " << ce << endl;
  debug(3) << "pam_dem::process  x = " << x << endl;

  N = ce.length();
  if(x.length() != N)
  {
    throw sim_exception("pam_dem::process - ce.size <> x.size", x.length());
  }

  iv.set_length(1);
  v.set_length(1);
  y.set_length(N);

  for(int i = 0; i < N; i++)
  {
    if(ce[i])
    {
      v[0]  = x[i] / scale;
      iv = demodulate(v);
      y0 = iv[0];
    }
    y[i] = y0;
  }

  debug(3) << "pam_dem::process  y = " << y << endl;

  return (y);
}


} // namespace SIM