/*xxx
* \brief - SIM::pam_mod - PAM modulator derived from itpp::PAM
* \author maki
*/

#include "sim\sim_pam_mod.hpp"
#include "sim\_sim_exception.hpp"
#include "__debug_level.h"
#include "debug.hpp"

namespace SIM
{

void pam_mod::set_size(int m)
{
  double max_val, norm_max_val;

  try
  {
    M = m;
    set_M(M);
  }
  catch(...)
  {
    throw sim_exception("pam_mod.set_size - bad size", m);
  }
  max_val = ((double)M - 1.0) / sqrt(((double)M * M - 1.0) / 3);
  // [-1,1] constellation
  norm_max_val = 1.0 - 1.0 / (double)M;
  // - to get +0.5 for 1, and so on
  scale = -norm_max_val / max_val;

}

void pam_mod::set_scale(double s)
{
  scale = s;
}

void pam_mod::set_output(double yout)
{
  y0 = yout;
}

int pam_mod::get_size()
{
  return (M);
}

double pam_mod::get_scale()
{
  return (scale);
}

double pam_mod::get_output()
{
  return (y0);
}

vec pam_mod::process(const bvec &ce, const ivec &x)
{
  vec y;
  int N;
  ivec iv;
  vec v;

  debug(3) << "pam_mod::process ce = " << ce << endl;
  debug(3) << "pam_mod::process  x = " << x << endl;

  N = ce.length();

  if(x.length() != N)
  {
    throw sim_exception("pam_mod::process - ce.size <> x.size", x.length());
  }
  
  y.set_length(N);
  iv.set_length(1);
  v.set_length(1);

  for(int i = 0; i < N; i++)
  {
    if(ce[i])
    {
      iv[0]  = x[i];
      v = modulate(iv);
      y0 = scale * v[0];
    }
    y[i] = y0;
  }

  debug(3) << "pam_mod::process  y = " << y << endl;

  return (y);
}

} // namespace SIM