/*xxx
* \brief - SIM::psk_dem - derived from itpp::PSK
* \author maki
*/

#include "sim\sim_psk_dem.hpp"
#include "sim\_sim_exception.hpp"
#include "__debug_level.h"
#include "debug.hpp"

namespace SIM
{


void psk_dem::set_size(int m)
{
  try
  {
    M = m;
    set_M(M);
  }
  catch(...)
  {
    throw sim_exception("psk_dem.set_size - bad size", m);
  }
  // [-1,1] -> QPSK <-> 4PSK
  // constellation for qpsk R^2 = I^2+Q^2 = 1/2
  if(M == 2)
  {
    scale = 0.5; //BPSK
  }
  else
  {
    scale = 1 / sqrt(2.0);
  }

}

void psk_dem::set_scale(double s)
{
  scale = s;
}

void psk_dem::set_output(int yout)
{
  y0 = yout;
}

int psk_dem::get_size()
{
  return (M);
}

double psk_dem::get_scale()
{
  return (scale);
}

int psk_dem::get_output()
{
  return (y0);
}

ivec psk_dem::process(const bvec &ce, const cvec &x)
{
  ivec y;
  int N;
  ivec iv;
  cvec cv;

  debug(3) << "psk_dem::process ce = " << ce << endl;
  debug(3) << "psk_dem::process  x = " << x << endl;

  iv.set_length(1);
  cv.set_length(1);
  N = ce.length();
  y.set_length(N);

  if(x.length() != N)
  {
    throw sim_exception("psk_dem::process - ce.size <> x.size", x.length());
  }

  for(int i = 0; i < N; i++)
  {
    if(ce[i])
    {
      cv[0]  = x[i] / scale;
      iv = demodulate(cv);
      y0 = iv[0];
    }
    y[i] = y0;
  }

  debug(3) << "psk_dem::process  y = " << y << endl;

  return (y);
}


} // namespace SIM