/*xxx
* \brief - SIM::psk_mod - derived from itpp::PSK
* \author maki
*/

#include "sim\sim_psk_mod.hpp"
#include "sim\_sim_exception.hpp"
#include "__debug_level.h"
#include "debug.hpp"

namespace SIM
{

void psk_mod::set_size(int m)
{
  try
  {
    M = m;
    set_M(M);
  }
  catch(...)
  {
    throw sim_exception("psk_mod.set_size - bad size", m);
  }
  // [-1,1] -> QPSK <-> 4PSK
  // constellation for qpsk R^2 = I^2+Q^2 = 1/2
  if(M == 2)
  {
    scale = 0.5; //BPSK
  }
  else
  {
    scale = 1 / sqrt(2.0);
  }
}

void psk_mod::set_scale(double s)
{
  scale = s;
}

void psk_mod::set_output(std::complex<double> yout)
{
  y0 = yout;
}

int psk_mod::get_size()
{
  return (M);
}

double psk_mod::get_scale()
{
  return (scale);
}

std::complex<double> psk_mod::get_output()
{
  return (y0);
}

cvec psk_mod::process(const bvec &ce, const ivec &x)
{
  cvec y;
  int N;
  ivec iv;
  cvec cv;

  debug(3) << "psk_mod::process ce = " << ce << endl;
  debug(3) << "psk_mod::process  x = " << x << endl;

  iv.set_length(1);
  cv.set_length(1);
  N = ce.length();
  y.set_length(N);

  if(x.length() != N)
  {
    throw sim_exception("psk_mod::process - ce.size <> x.size", x.length());
  }

  for(int i = 0; i < N; i++)
  {
    if(ce[i])
    {
      iv[0]  = x[i];
      cv = modulate(iv);
      y0 = scale * cv[0];
    }
    y[i] = y0;
  }

  debug(3) << "psk_mod::process  y = " << y << endl;

  return (y);
}


} // namespace SIM