/*xxx
* \brief - SIM::qam_dem - derived from itpp::QAM
* \author maki
*/

#include "sim\sim_qam_dem.hpp"
#include "sim\_sim_exception.hpp"
#include "__debug_level.h"
#include "debug.hpp"

namespace SIM
{

void qam_dem::set_size(int m)
{
  double max_val;
  double norm_max_val;

  try
  {
    M = m;
    set_M(M);
  }
  catch(...)
  {
    throw sim_exception("qam_dem.set_size - bad size", m);
  }
  // [-1,1] constellation
  max_val = (sqrt((double)M) - 1.0) / sqrt(2 * ((double)M - 1.0) / 3);
  norm_max_val = 1.0 - 1.0 / sqrt((double)M);
  scale = norm_max_val / max_val;
}

void qam_dem::set_scale(double s)
{
  scale = s;
}

void qam_dem::set_output(int yout)
{
  y0 = yout;
}

int qam_dem::get_size()
{
  return (M);
}

double qam_dem::get_scale()
{
  return (scale);
}

int qam_dem::get_output()
{
  return (y0);
}

ivec qam_dem::process(const bvec &ce, const cvec &x)
{
  ivec y;
  int N;
  ivec iv;
  cvec cv;

  debug(3) << "qam_dem::process() \n ce=" << ce << "\n x=" << x << endl;

  iv.set_length(1); // used as temp in the processing loop
  cv.set_length(1); // used as temp in the processing loop

  N = ce.length();
  y.set_length(N);

  if(x.length() != N)
  {
    throw sim_exception("qam_dem::process() - ce.size <> x.size", x.length());
  }

  for(int i = 0; i < N; i++)
  {
    if(ce[i])
    {
      cv[0]  = x[i] / scale;
      iv = demodulate(cv);
      y0 = iv[0];
    }
    y[i] = y0;
  }
  debug(3) << "qam_dem::process() \n y=" << y << endl;
  return (y);
}

} // namespace SIM