/*xxx
* \brief - SIM::qam_mod QAM modulator derived from itpp::QAM
* \author maki
*/

#include "sim\sim_qam_mod.hpp"
#include "sim\_sim_exception.hpp"
#include "__debug_level.h"
#include "debug.hpp"

namespace SIM
{


void qam_mod::set_size(int m)
{
  double max_val;
  double norm_max_val;

  try
  {
    M = m;
    set_M(M);
  }
  catch(...)
  {
    throw sim_exception("qam_mod.set_size - bad size", m);
  }
  // [-1,1] constellation
  max_val = (sqrt((double)M) - 1.0) / sqrt(2 * ((double)M - 1.0) / 3);
  norm_max_val = 1.0 - 1.0 / sqrt((double)M);
  scale = norm_max_val / max_val;
}

void qam_mod::set_scale(double s)
{
  scale = s;
}

void qam_mod::set_output(complexd yout)
{
  y0 = yout;
}

int qam_mod::get_size()
{
  return (M);
}

double qam_mod::get_scale()
{
  return (scale);
}

complexd qam_mod::get_output()
{
  return (y0);
}

cvec qam_mod::process(const bvec &ce, const ivec &x)
{
  cvec y;
  int N;
  ivec iv;
  cvec cv;

  debug(3) << "qam_mod::process ce = " << ce  << endl;
  debug(3) << "qam_mod::process  x = " << x << endl;

  iv.set_length(1); // used as temp in the processing loop
  cv.set_length(1); // used as temp in the processing loop
  N = ce.length();
  y.set_length(N);

  if(x.length() != N)
  {
    throw sim_exception("qam_mod::process() - ce.size <> x.size", x.length());
  }

  for(int i = 0; i < N; i++)
  {
    if(ce[i])
    {
      iv[0]  = x[i];
      cv = modulate(iv);
      y0 = scale * cv[0];
    }
    y[i] = y0;
  }
  debug(3) << "qam_mod::process y = " << y << endl;
  return (y);
}


} // namespace SIM