/*xxx
* \brief - SIM::rms - real signal RMS processor using moving average MAV fir
* \author maki
*/

#include "sim\sim_rms.hpp"
#include "sim\_sim_exception.hpp"
#include "__debug_level.h"
#include "debug.hpp"

namespace SIM
{

void rms::set_size(int n)
{
  vec c0;

  if(n > 0)
  {
    N = n;
  }
  else
  {
    throw sim_exception("rms::set_size N = ", N);
  }
  c0 = (1.0 / N) * ones(N);
  fir_mav.set_taps(c0);
  fir_mav.reset();
}


void rms::set_output(double yout)
{
  y0 = yout;
}

int rms::get_size(void)
{
  return(N);
}

double rms::get_output(void)
{
  return(y0);
}


vec rms::process(const bvec &ce, const vec &x)
{
  vec y, y1;
  int L;
  bvec one("1");
  vec sample = "0.0";

  debug(3) << "rms::process() ce=" << ce << endl;
  debug(3) << "rms::process()  x=" << x << endl;
  L = ce.length();

  if(x.size() != L)
  {
    throw sim_exception("rms::process() - ce.size <> x.size", x.size());
  }

  y.set_size(L);

  for(int i = 0; i < L; i++)
  {
    if(bool(ce[i]))
    {
      // y1 = fir_mav.process(one, to_vec(x[i]*x[i]));
      sample[0] = x[i] * x[i];
      y1 = fir_mav.process(one, sample);
      y0 = sqrt(fabs(y1[0]));  // sqrt(mav<x^2>)
    }
    y[i] = y0;
  }

  debug(3) << "rms::process() y=" << y << endl;
  return (y);
}



} // namespace SIM