/*xxx
* \brief - SIM::rms_x - complex signal RMS measuring block using moving average MAV fir
* \author maki
*/

#include "sim\sim_rms_x.hpp"
#include "sim\_sim_exception.hpp"
#include "__debug_level.h"
#include "debug.hpp"

namespace SIM
{

void rms_x::set_size(int n)
{
  vec c0;

  if(n > 0)
  {
    N = n;
  }
  else
  {
    throw sim_exception("rms::set_size N = ", N);
  }
  c0 = (1.0 / N) * ones(N);
  fir_mav.set_taps(c0);
  fir_mav.reset();
}

void rms_x::set_output(double yout)
{
  y0 = yout;
}

int rms_x::get_size(void)
{
  return(N);
}

double rms_x::get_output(void)
{
  return(y0);
}


vec rms_x::process(const bvec &ce, const cvec &x)
{
  vec y, y1;
  int L;
  bvec one("1");
  vec sample = "0.0";

  debug(3) << "rms_x::process ce=" << ce << endl;
  debug(3) << "rms_x::process  x=" << x << endl;
  L = ce.length();

  if(x.size() != L)
  {
    throw sim_exception("rms::process() - ce.size <> x.size", x.size());
  }

  y.set_size(L);
  for(int i = 0; i < L; i++)
  {
    if(bool(ce[i]))
    {
      // y2 = abs( x[i] * (std::conj(x[i])));
      // y1 = fir_mav.process(one, to_vec(y2));
      sample[0] = abs(x[i] * (std::conj(x[i])));
      y1 = fir_mav.process(one, sample);
      y0 = sqrt(fabs(y1[0]));  // sqrt(mav<x^2>)
    }
    y[i] = y0;
  }

  debug(3) << "rms_x::process y=" << y << endl;
  return (y);
}

} // namespace SIM