/*xxx
* \brief - SIM::src_x  - complex sample rate converter with sinc fir reconstruction filter
* \author maki
*/


#include "sim\sim_src_x.hpp"
#include "sim\_sim_exception.hpp"
#include "sim\_sim_enum_def.h"
#include "__debug_level.h"
#include "debug.hpp"

namespace SIM
{

void src_x::set_size(int n)
{
  src_i.set_size(n);
  src_q.set_size(n);
  return;
}

void src_x::set_win_type(int w)
{
  src_i.set_win_type(w);
  src_q.set_win_type(w);
  return;
}

void src_x::set_output(complexd yout)
{
  y0 = yout;
}

int src_x::get_size(void)
{
  return (src_i.get_size());
}

int src_x::get_win_type(void)
{
  return (src_i.get_win_type());
}

complex<double> src_x::get_output(void)
{
  return (y0);
}

cvec src_x::process(const bmat &ceio, const cmat &xt)
{
  cvec y;
  int K;

  debug(3) << "src_x::process ceio = " << ceio << endl;
  debug(3) << "src_x::process   xt = " << xt << endl;

  if(ceio.cols() != 2)
  {
    throw sim_exception("src_x::process - ceio.cols() <> 2 ", ceio.cols());
  }
  if(xt.cols() != 2)
  {
    throw sim_exception("src_x::process - xt.cols() <> 2 ", xt.cols());
  }
  if(xt.rows() != ceio.rows())
  {
    throw sim_exception("src_x::process - xt.rows() <> ceio.rows() ", xt.rows());
  }
  K = ceio.rows();
  y.set_length(K);
  for(int i = 0; i < K; i++)
  {
    // cei - input sample to x_cb
    if(bool(ceio(i, 0)))
    {
      src_i.xcb(real(xt(i, 0)));
      src_q.xcb(imag(xt(i, 0)));
    }
    // ceo - re_samp for tau
    if(bool(ceio(i, 1)))
    {
      // time is real - not complex!
      src_i.y0 = src_i.re_samp(real(xt(i, 1)));
      // time is real - not complex!
      src_q.y0 = src_q.re_samp(real(xt(i, 1)));
      y0 = complex<double>(src_i.y0, src_q.y0);
    }
    y(i) = y0;
  }
  debug(3) << "src_x::process    y = " << y << endl;
  return (y);
}

} // namespace SIM