/*xxx
* \brief - SIM::tedg_x  - dual timing error detector - gardner with mods
* \author maki
*/

#include "sim\sim_tedg_x.hpp"
#include "sim\_sim_exception.hpp"
#include "__debug_level.h"
#include "debug.hpp"

namespace SIM
{

void tedg_x::set_mode(int m)
{
  switch(m)
  {
    case TEDG_MODE_STD:
    case TEDG_MODE_EDGE:
    case TEDG_MODE_PUMP:
      op_mode = (tedg_mode)m;
      break;
    default:
      throw sim_exception("tedg_x::set_mode - bad type", m);
      break;
  }
  return;
}

void tedg_x::set_quantum(double q)
{
  quantum = q;
}

void tedg_x::set_output(complexd yout)
{
  y0 = yout;
}

int tedg_x::get_mode(void)
{
  return (op_mode);
}

double tedg_x::get_quantum(void)
{
  return (quantum);
}

complex<double> tedg_x::get_output(void)
{
  return (y0);
}

cvec tedg_x::process(const bmat &ceio, const cvec &x)
{
  cvec y;
  int K, i;
  double y0i, y0q;

  debug(3) << "tedg_x::process ceio = " << ceio << endl;
  debug(3) << "tedg_x::process    x = " << x << endl;

  if(ceio.cols() != 2)
  {
    throw sim_exception("tedg_x::process - ceio.cols() <> 2 ", ceio.cols());
  }
  if(x.length() != ceio.rows())
  {
    throw sim_exception("tedg_x::process - x.lenght() <> ceio.rows() ", x.length());
  }

  K = ceio.rows();
  y.set_length(K);
  for(i = 0; i < K; i++)
  {
    // cei - input sample to x_cb
    if(ceio(i, 0))
    {
      x2 = x1;
      x1 = x0;
      x0 = x(i);
    }
    // ceo
    if(ceio(i, 1))
    {
      switch(op_mode)
      {
        case TEDG_MODE_STD:
          y0i = (x0.real() - x2.real()) * (x1.real());
          y0q = (x0.imag() - x2.imag()) * (x1.imag());
          y0 = complexd(y0i, y0q);
          break;
        case TEDG_MODE_EDGE:
          if((x0.real() > 0.0) && (x2.real() < 0.0))
          {
            y0i = x1.real();
          }
          else if((x0.real() < 0.0) && (x2.real() > 0.0))
          {
            y0i = - x1.real();
          }
          else
          {
            y0i = 0.0;
          };
          if((x0.imag() > 0.0) && (x2.imag() < 0.0))
          {
            y0q = x1.imag();
          }
          else if((x0.imag() < 0.0) && (x2.imag() > 0.0))
          {
            y0q = - x1.imag();
          }
          else
          {
            y0q = 0.0;
          };
          y0 = complexd(y0i, y0q);
          break;
        case TEDG_MODE_PUMP:
          if((x0.real() > 0.0) && (x2.real() < 0.0))
          {
            y0i = sgn(x1.real());
          }
          else if((x0.real() < 0.0) && (x2.real() > 0.0))
          {
            y0i = - sgn(x1.real());
          }
          else
          {
            y0i = 0.0;
          };
          if((x0.imag() > 0.0) && (x2.imag() < 0.0))
          {
            y0q = sgn(x1.imag());
          }
          else if((x0.imag() < 0.0) && (x2.imag() > 0.0))
          {
            y0q = - sgn(x1.imag());
          }
          else
          {
            y0q = 0.0;
          };
          y0 = complexd(y0i, y0q) * quantum;
          break;

        default:
          throw sim_exception("tedg_x::process - bad mode", op_mode);
          break;
      }
    }
    y(i) = y0;
  }

  debug(3) << "tedg_x::process  y = " << y << endl;
  return (y);
}

} // namespace SIM