/*xxx
* \brief vco - NCO with floating point accumulator ph=(-1.0..1.0)
* \author maki
*/

#include "sim\sim_vco.hpp"
#include "sim\_sim_exception.hpp"
#include "__debug_level.h"
#include "debug.hpp"

namespace SIM
{

void vco::set_output(const vec &yout)
{
  if(yout.length() ==  2)
  {
    y0 = yout;
  }
  else
  {
    throw sim_exception("vco::set_output - invalid size ", yout.length());
  }

}

void vco::set_acc(double a)
{
  // saturation
  if(a >= 1.0)
  {
    ph = 1.0 - DBL_EPSILON;
  }
  else if(a <= -1.0)
  {
    ph = -(1.0 - DBL_EPSILON);
  }
  else
  {
    ph = a;
  }
}

vec vco::get_output(void)
{
  return (y0);
}

double vco::get_acc(void)
{
  return (ph);
}

mat vco::process(const bvec &ce, const vec &x)
{
  int N;
  double fcw;
  double cy;
  mat y;

  debug(3) << " vco::process() ce = " << ce << endl;
  debug(3) << " vco::process()  x = " << x << endl;

  N = ce.length();
  if(x.length() != N)
  {
    throw sim_exception("nco::process - ce.size <> x.size()", x.length());
  }
  y.set_size(N, 2);

  y.set_size(N, 2);
  for(int i = 0; i < N; i++)
  {
    if(bool(ce[i]))
    {
      // input saturation with symmetric limits
      if(x[i] >= 1.0)
      {
        fcw = 1.0 - DBL_EPSILON;
      }
      else if(x[i] <= -1.0)
      {
        fcw = -(1.0 - DBL_EPSILON);
      }
      else
      {
        fcw = x[i];
      }

      // phase accumulation
      ph = ph + fcw;
      // phase wrapping -1.0 < ph < 1.0 with cy for +1, -1 overflows
      if(ph >= 1.0)
      {
        ph -= 1.0;
        cy = 1;
      }
      else if(ph <= -1.0)
      {
        ph += 1.0;
        cy = -1;
      }
      else
      {
        cy = 0;
      }
      y0(0) = cy;
      y0(1) = ph;
    }
    y.set_row(i, y0);
  }

  debug(3) << "nco::process() y=" << y << endl;
  return (y);
}

} // namespace SIM